/*
 * Decompiled with CFR 0.152.
 */
package com.tisonkun.os.maven;

import com.tisonkun.os.core.Detector;
import com.tisonkun.os.core.FileOperationProvider;
import com.tisonkun.os.core.SystemPropertyOperationProvider;
import com.tisonkun.os.maven.DetectExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.api.spi.PropertyContributor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;

@Component(role=PropertyContributor.class)
public class DetectPropertyContributor
implements PropertyContributor {
    private final Logger logger;

    @Inject
    DetectPropertyContributor(Logger logger) {
        this.logger = logger;
    }

    public void contribute(Map<String, String> map) {
        this.logger.info("The os-detector Maven 4 extension is registered, OS and CPU architecture properties will be provided.");
        DetectExtension.disable();
        Properties props = new Properties();
        props.putAll(map);
        Detector detector = new Detector((SystemPropertyOperationProvider)new SimpleSystemPropertyOperations(map), (FileOperationProvider)new SimpleFileOperations(), arg_0 -> ((Logger)this.logger).debug(arg_0));
        detector.detect(props);
    }

    private static class SimpleSystemPropertyOperations
    implements SystemPropertyOperationProvider {
        final Map<String, String> map;

        private SimpleSystemPropertyOperations(Map<String, String> map) {
            this.map = map;
        }

        public String getSystemProperty(String name) {
            return System.getProperty(name);
        }

        public String getSystemProperty(String name, String def) {
            return System.getProperty(name, def);
        }

        public String setSystemProperty(String name, String value) {
            this.map.put(name, value);
            return System.setProperty(name, value);
        }
    }

    private static class SimpleFileOperations
    implements FileOperationProvider {
        private SimpleFileOperations() {
        }

        public InputStream readFile(String fileName) throws IOException {
            return Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
        }
    }
}

