/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import com.titusfortner.logging.SeleniumFilter;
import com.titusfortner.logging.SeleniumFormatter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeleniumLogger {
    private Handler handler = new ConsoleHandler();
    private Level level = Level.INFO;
    private Filter filter = new SeleniumFilter();
    private Formatter formatter = new SeleniumFormatter();
    private File file;
    public final Logger rootLogger = Logger.getLogger("");

    public static SeleniumLogger enable() {
        SeleniumLogger logger = new SeleniumLogger();
        logger.setLevel(Level.FINE);
        return logger;
    }

    public static SeleniumLogger enable(String name, String ... names) {
        SeleniumLogger logger = SeleniumLogger.enable();
        if (name != null) {
            logger.filter(name, names);
        }
        return logger;
    }

    public static SeleniumLogger all() {
        SeleniumLogger logger = new SeleniumLogger();
        SeleniumFilter seleniumFilter = new SeleniumFilter();
        seleniumFilter.addAllowed("");
        logger.setFilter(seleniumFilter);
        logger.setLevel(Level.ALL);
        return logger;
    }

    public SeleniumLogger() {
        System.setProperty("webdriver.remote.shorten_log_messages", "true");
        this.updateLogger();
    }

    public void setFullLogMessages(Boolean fullLogMessages) {
        System.setProperty("webdriver.remote.shorten_log_messages", String.valueOf(fullLogMessages == false));
    }

    public void setLevel(Level level) {
        Objects.requireNonNull(level);
        this.level = level;
        this.updateLogger();
    }

    public Level getLevel() {
        return this.level;
    }

    public void disable() {
        this.level = Level.OFF;
        this.updateLogger();
    }

    public void setFormatter(Formatter formatter) {
        Objects.requireNonNull(formatter);
        this.formatter = formatter;
        this.updateLogger();
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFileOutput(File file) {
        Objects.requireNonNull(file);
        this.file = file;
        try {
            this.handler = new FileHandler(file.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.updateLogger();
    }

    public File getFileOutput() {
        return this.file;
    }

    public void filter(String name, String ... names) {
        Objects.requireNonNull(name);
        SeleniumFilter filter = new SeleniumFilter();
        filter.clear();
        filter.addAllowed(name);
        Arrays.stream(names).forEach(filter::addAllowed);
        this.setFilter(filter);
    }

    public void filterOut(String name, String ... names) {
        Objects.requireNonNull(name);
        SeleniumFilter filter = new SeleniumFilter();
        filter.addBlocked(name);
        Arrays.stream(names).forEach(filter::addBlocked);
        this.setFilter(filter);
    }

    public void setFilter(Filter filter) {
        Objects.requireNonNull(filter);
        this.filter = filter;
        this.updateLogger();
    }

    public Filter getFilter() {
        return this.filter;
    }

    private void updateLogger() {
        Arrays.stream(this.rootLogger.getHandlers()).forEach(this.rootLogger::removeHandler);
        this.rootLogger.setLevel(this.getLevel());
        this.handler.setFormatter(this.getFormatter());
        this.handler.setLevel(this.getLevel());
        this.handler.setFilter(this.getFilter());
        this.rootLogger.addHandler(this.handler);
    }
}

