/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.gradle;

import com.tngtech.jgiven.gradle.JGivenReportTask;
import com.tngtech.jgiven.gradle.JGivenTaskExtension;
import com.tngtech.jgiven.impl.util.WordUtil;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.Test;

@NonNullApi
public abstract class JGivenPlugin
implements Plugin<Project> {
    @Inject
    protected abstract ObjectFactory getObjects();

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.addTaskExtension(project);
        this.addDefaultReports(project);
        this.configureJGivenReportDefaults(project);
    }

    private void addTaskExtension(Project project) {
        project.getTasks().withType(Test.class).configureEach(this::applyTo);
    }

    private void applyTo(Test test) {
        String testName = test.getName();
        Project project = test.getProject();
        final JGivenTaskExtension extension = (JGivenTaskExtension)this.getObjects().newInstance(JGivenTaskExtension.class, new Object[0]);
        test.getExtensions().add("jgiven", (Object)extension);
        extension.getResultsDir().convention(project.getLayout().getBuildDirectory().dir("jgiven-results/" + testName));
        DirectoryProperty resultsDir = extension.getResultsDir();
        test.getOutputs().dir((Object)resultsDir).withPropertyName("jgiven.resultsDir");
        test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                ((Test)task).systemProperty("jgiven.report.dir", (Object)((Directory)extension.getResultsDir().get()).getAsFile().getAbsolutePath());
            }
        });
    }

    private void configureJGivenReportDefaults(Project project) {
        project.getTasks().withType(JGivenReportTask.class).configureEach(reportTask -> reportTask.getReports().all(report -> report.getRequired().convention((Object)report.getName().equals("html"))));
    }

    private void addDefaultReports(Project project) {
        ReportingExtension reportingExtension = Objects.requireNonNull((ReportingExtension)project.getExtensions().findByType(ReportingExtension.class));
        project.getTasks().withType(Test.class).forEach(test -> project.getTasks().register("jgiven" + WordUtil.capitalize((String)test.getName()) + "Report", JGivenReportTask.class).configure(reportTask -> this.configureDefaultReportTask((Test)test, (JGivenReportTask)((Object)((Object)reportTask)), reportingExtension)));
    }

    private void configureDefaultReportTask(Test test, JGivenReportTask reportTask, ReportingExtension reportingExtension) {
        DirectoryProperty resultsDirectory = ((JGivenTaskExtension)test.getExtensions().getByType(JGivenTaskExtension.class)).getResultsDir();
        reportTask.getResults().convention((Provider)resultsDirectory);
        String relativeFilePath = "jgiven/" + test.getName() + "/";
        Provider reportOutputLocation = reportingExtension.getBaseDirectory().dir(relativeFilePath);
        reportTask.getReports().configureEach(report -> report.getOutputLocation().set(reportOutputLocation.map(d -> d.dir(report.getName()))));
    }
}

