/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.gradle;

import com.tngtech.jgiven.gradle.JGivenReport;
import com.tngtech.jgiven.gradle.JGivenReportsContainer;
import com.tngtech.jgiven.gradle.internal.JGivenReportsContainerImpl;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@NonNullApi
public abstract class JGivenReportTask
extends DefaultTask
implements Reporting<JGivenReportsContainer> {
    private final JGivenReportsContainer reports = (JGivenReportsContainer)this.getObjects().newInstance(JGivenReportsContainerImpl.class, new Object[]{this});

    @Inject
    protected abstract ObjectFactory getObjects();

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getResults();

    @TaskAction
    public void generate() {
        this.getReports().stream().filter(report -> (Boolean)report.getRequired().get()).forEach(this::generateReport);
    }

    private void generateReport(JGivenReport report) {
        AbstractReportGenerator generator = report.createGenerator();
        generator.config.setSourceDir(((Directory)this.getResults().get()).getAsFile());
        generator.loadReportModel();
        try {
            generator.generate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nested
    public JGivenReportsContainer getReports() {
        return this.reports;
    }

    public JGivenReportsContainer reports(Closure closure) {
        return (JGivenReportsContainer)this.reports.configure(closure);
    }

    public JGivenReportsContainer reports(Action<? super JGivenReportsContainer> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }
}

