/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.gradle.internal;

import com.tngtech.jgiven.gradle.JGivenReport;
import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.ReportGenerator;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportConfig;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportGenerator;
import com.tngtech.jgiven.report.html5.Html5ReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import groovy.lang.Closure;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.Internal;
import org.gradle.util.internal.ConfigureUtil;

@NonNullApi
public abstract class AbstractJGivenReportImpl
implements JGivenReport {
    private File customCssFile;
    private File customJsFile;
    private String title;
    private boolean excludeEmptyScenarios = false;
    private boolean thumbnailsAreShown = true;
    private final String taskPath;
    private final String name;
    private final String relativeEntryPath;

    public AbstractJGivenReportImpl(String name, Task task, String relativeEntryPath) {
        this.name = name;
        this.taskPath = task.getPath();
        this.relativeEntryPath = relativeEntryPath;
        this.getRequired().convention((Object)false);
    }

    @Override
    public AbstractReportGenerator createGenerator() {
        AsciiDocReportConfig conf;
        AsciiDocReportGenerator generator = switch (this.getFormat()) {
            case ReportGenerator.Format.ASCIIDOC -> {
                conf = new AsciiDocReportConfig();
                yield new AsciiDocReportGenerator();
            }
            case ReportGenerator.Format.TEXT -> {
                conf = new PlainTextReportConfig();
                yield new PlainTextReportGenerator();
            }
            default -> {
                Html5ReportConfig customConf = new Html5ReportConfig();
                customConf.setShowThumbnails(this.isThumbnailsAreShown());
                if (this.getCustomCssFile() != null) {
                    customConf.setCustomCss(this.getCustomCssFile());
                }
                if (this.getCustomJsFile() != null) {
                    customConf.setCustomJs(this.getCustomJsFile());
                }
                conf = customConf;
                yield ReportGenerator.generateHtml5Report();
            }
        };
        if (this.getTitle() != null) {
            conf.setTitle(this.getTitle());
        }
        conf.setTargetDir((File)this.getOutputLocation().getAsFile().get());
        conf.setExcludeEmptyScenarios(Boolean.valueOf(this.isExcludeEmptyScenarios()));
        generator.setConfig((AbstractReportConfig)conf);
        return generator;
    }

    @Internal
    public abstract ReportGenerator.Format getFormat();

    @Override
    @Nullable
    public File getCustomCssFile() {
        return this.customCssFile;
    }

    @Override
    public void setCustomCssFile(File customCssFile) {
        this.customCssFile = customCssFile;
    }

    @Override
    @Nullable
    public File getCustomJsFile() {
        return this.customJsFile;
    }

    @Override
    public void setCustomJsFile(File customJsFile) {
        this.customJsFile = customJsFile;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean isExcludeEmptyScenarios() {
        return this.excludeEmptyScenarios;
    }

    @Override
    public void setExcludeEmptyScenarios(boolean excludeEmptyScenarios) {
        this.excludeEmptyScenarios = excludeEmptyScenarios;
    }

    @Override
    public boolean isThumbnailsAreShown() {
        return this.thumbnailsAreShown;
    }

    @Override
    public void setThumbnailsAreShown(boolean thumbnailsAreShown) {
        this.thumbnailsAreShown = thumbnailsAreShown;
    }

    public File getEntryPoint() {
        return new File((File)this.getOutputLocation().getAsFile().getOrNull(), this.relativeEntryPath);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return "Report generated by task '" + this.taskPath + "' (" + this.name + ")";
    }

    public abstract Property<Boolean> getRequired();

    public abstract DirectoryProperty getOutputLocation();

    @Deprecated
    public void setDestination(File file) {
        throw new UnsupportedOperationException("Use outputLocation instead");
    }

    public Report.OutputType getOutputType() {
        return Report.OutputType.DIRECTORY;
    }

    public Report configure(Closure configure) {
        return (Report)ConfigureUtil.configureSelf((Closure)configure, (Object)this);
    }
}

