/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html5;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.report.model.AttachmentModel;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Html5AttachmentGenerator
extends ReportModelVisitor {
    private static final Logger log = LoggerFactory.getLogger(Html5AttachmentGenerator.class);
    private static final String ATTACHMENT_DIRNAME = "attachments";
    private File attachmentsDir;
    private String subDir;
    private Multiset<String> fileCounter = HashMultiset.create();
    private Set<String> usedFileNames = Sets.newHashSet();
    private String htmlSubDir;

    Html5AttachmentGenerator() {
    }

    public void generateAttachments(File targetDir, ReportModel model) {
        this.subDir = ATTACHMENT_DIRNAME + File.separatorChar + model.getClassName().replace('.', File.separatorChar);
        this.htmlSubDir = this.subDir.replace(File.separatorChar, '/');
        this.attachmentsDir = new File(targetDir, this.subDir);
        if (!this.attachmentsDir.exists() && !this.attachmentsDir.mkdirs()) {
            throw new JGivenInstallationException("Could not create directory " + this.attachmentsDir);
        }
        model.accept((ReportModelVisitor)this);
    }

    public void visit(StepModel stepModel) {
        AttachmentModel attachment = stepModel.getAttachment();
        if (attachment == null) {
            return;
        }
        String mimeType = attachment.getMediaType();
        MediaType mediaType = MediaType.parse((String)mimeType);
        File targetFile = null;
        if (mediaType.is(MediaType.ANY_TEXT_TYPE)) {
            targetFile = this.writeTextFile(attachment);
        } else if (mediaType.is(MediaType.ANY_IMAGE_TYPE)) {
            targetFile = this.writeImageFile(attachment, mediaType);
        }
        if (targetFile != null) {
            attachment.setValue(this.htmlSubDir + "/" + targetFile.getName());
        } else {
            attachment.setValue(null);
        }
        log.info("Attachment written to " + targetFile);
    }

    private File writeImageFile(AttachmentModel attachment, MediaType mediaType) {
        String extension = this.getExtension(mediaType);
        File targetFile = this.getTargetFile(attachment.getFileName(), extension);
        try {
            Files.write((byte[])DatatypeConverter.parseBase64Binary((String)attachment.getValue()), (File)targetFile);
        }
        catch (IOException e) {
            log.error("Error while trying to write attachment to file " + targetFile, (Throwable)e);
        }
        return targetFile;
    }

    private String getExtension(MediaType mediaType) {
        if (mediaType.is(MediaType.SVG_UTF_8)) {
            return "svg";
        }
        if (mediaType.is(MediaType.ICO)) {
            return "ico";
        }
        if (mediaType.is(MediaType.BMP)) {
            return "bmp";
        }
        return mediaType.subtype();
    }

    File getTargetFile(String fileName, String extension) {
        if (fileName == null) {
            fileName = "attachment";
        }
        int count = this.fileCounter.count((Object)fileName);
        this.fileCounter.add((Object)fileName);
        String suffix = "";
        if (count > 0) {
            suffix = String.valueOf(++count);
        }
        String fileNameWithExtension = fileName + suffix + "." + extension;
        while (this.usedFileNames.contains(fileNameWithExtension)) {
            this.fileCounter.add((Object)fileName);
            suffix = String.valueOf(++count);
            fileNameWithExtension = fileName + suffix + "." + extension;
        }
        this.usedFileNames.add(fileNameWithExtension);
        return new File(this.attachmentsDir, fileNameWithExtension);
    }

    private File writeTextFile(AttachmentModel attachment) {
        File targetFile = this.getTargetFile(attachment.getFileName(), "txt");
        try {
            Files.write((CharSequence)attachment.getValue(), (File)targetFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error while trying to write attachment to file " + targetFile, (Throwable)e);
        }
        return targetFile;
    }
}

