/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html5;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.html5.Html5AttachmentGenerator;
import com.tngtech.jgiven.report.html5.TagFile;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.model.ScenarioModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Html5ReportGenerator
extends AbstractReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(Html5ReportGenerator.class);
    private static final int MAX_BATCH_SIZE = 100;
    private PrintStream writer;
    private MetaData metaData = new MetaData();
    private int caseCountOfCurrentBatch;
    private File dataDirectory;

    public void generate() {
        log.info("Generating HTML5 report to {}", (Object)new File(this.targetDirectory, "index.html").getAbsoluteFile());
        this.dataDirectory = new File(this.targetDirectory, "data");
        this.metaData.title = this.config.getTitle();
        if (!this.dataDirectory.exists() && !this.dataDirectory.mkdirs()) {
            log.error("Could not create target directory " + this.dataDirectory);
            return;
        }
        try {
            this.unzipApp(this.targetDirectory);
            this.createDataFiles();
            this.generateMetaData();
            this.generateTagFile();
            this.copyCustomFile(this.config.getCustomCssFile(), new File(this.targetDirectory, "css"), "custom.css");
            this.copyCustomFile(this.config.getCustomJsFile(), new File(this.targetDirectory, "js"), "custom.js");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void copyCustomFile(File file, File targetDirectory, String targetName) throws IOException {
        if (file != null) {
            if (!file.canRead()) {
                log.info("Cannot read " + file + ", skipping");
            } else {
                Files.copy((File)file, (File)new File(targetDirectory, targetName));
            }
        }
    }

    private void createDataFiles() {
        for (ReportModelFile file : this.completeReportModel.getAllReportModels()) {
            this.handleReportModel(file.model, file.file);
        }
        this.closeWriter();
    }

    public void handleReportModel(ReportModel model, File file) {
        new Html5AttachmentGenerator().generateAttachments(this.dataDirectory, model);
        this.createWriter();
        this.caseCountOfCurrentBatch += this.getCaseCount(model);
        model.setTagMap(null);
        new Gson().toJson((Object)model, (Appendable)this.writer);
        this.writer.append(",");
        if (this.caseCountOfCurrentBatch > 100) {
            this.closeWriter();
        }
    }

    private int getCaseCount(ReportModel model) {
        int count = 0;
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            count += scenarioModel.getScenarioCases().size();
        }
        return count;
    }

    private void closeWriter() {
        if (this.writer != null) {
            this.writer.append("]);");
            this.writer.flush();
            ResourceUtil.close((Closeable[])new Closeable[]{this.writer});
            this.writer = null;
            log.info("Written " + this.caseCountOfCurrentBatch + " scenarios to " + this.metaData.data.get(this.metaData.data.size() - 1));
        }
    }

    private void createWriter() {
        if (this.writer == null) {
            String fileName = "data" + this.metaData.data.size() + ".js";
            this.metaData.data.add(fileName);
            File targetFile = new File(this.dataDirectory, fileName);
            log.debug("Generating " + targetFile + "...");
            this.caseCountOfCurrentBatch = 0;
            try {
                this.writer = new PrintStream((OutputStream)new FileOutputStream(targetFile), false, "utf-8");
                this.writer.append("jgivenReport.addScenarios([");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not open file " + targetFile + " for writing", e);
            }
        }
    }

    private void generateMetaData() throws IOException {
        File metaDataFile = new File(this.dataDirectory, "metaData.js");
        log.debug("Generating " + metaDataFile + "...");
        String content = "jgivenReport.setMetaData(" + new Gson().toJson((Object)this.metaData) + " );";
        Files.write((CharSequence)content, (File)metaDataFile, (Charset)Charsets.UTF_8);
    }

    private void generateTagFile() throws IOException {
        File tagFile = new File(this.dataDirectory, "tags.js");
        log.debug("Generating " + tagFile + "...");
        TagFile tagFileContent = new TagFile();
        tagFileContent.fill(this.completeReportModel.getTagIdMap());
        String content = "jgivenReport.setTags(" + new Gson().toJson((Object)tagFileContent) + " );";
        Files.write((CharSequence)content, (File)tagFile, (Charset)Charsets.UTF_8);
    }

    protected void unzipApp(File toDir) throws IOException {
        ZipEntry entry;
        String appZipPath = "/" + Html5ReportGenerator.class.getPackage().getName().replace('.', '/') + "/app.zip";
        log.debug("Unzipping {}...", (Object)appZipPath);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(appZipPath);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((entry = zipInputStream.getNextEntry()) != null) {
            int len;
            File file = new File(toDir, entry.getName());
            if (entry.isDirectory()) {
                if (file.exists()) continue;
                log.debug("Creating directory {}...", (Object)file);
                if (file.mkdirs()) continue;
                throw new IOException("Could not create directory " + file);
            }
            log.debug("Unzipping {}...", (Object)file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = zipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
            fileOutputStream.close();
        }
    }

    static class MetaData {
        Date created = new Date();
        String title = "JGiven Report";
        List<String> data = Lists.newArrayList();

        MetaData() {
        }
    }
}

