/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.report.model.AttachmentModel;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Html5AttachmentGenerator
extends ReportModelVisitor {
    private static final Logger log = LoggerFactory.getLogger(Html5AttachmentGenerator.class);
    private static final String ATTACHMENT_DIRNAME = "attachments";
    public static final int MINIMAL_THUMBNAIL_SIZE = 20;
    private File attachmentsDir;
    private String subDir;
    private final Multiset<String> fileCounter = HashMultiset.create();
    private final Set<String> usedFileNames = Sets.newHashSet();
    private String htmlSubDir;

    public Html5AttachmentGenerator() {
    }

    @VisibleForTesting
    public Html5AttachmentGenerator(File attachmentsDir) {
        this.attachmentsDir = attachmentsDir;
    }

    public void generateAttachments(File targetDir, ReportModel model) {
        this.subDir = ATTACHMENT_DIRNAME + File.separatorChar + model.getClassName().replace('.', File.separatorChar);
        this.htmlSubDir = this.subDir.replace(File.separatorChar, '/');
        this.attachmentsDir = new File(targetDir, this.subDir);
        if (!this.attachmentsDir.exists() && !this.attachmentsDir.mkdirs()) {
            throw new JGivenInstallationException("Could not create directory " + this.attachmentsDir);
        }
        model.accept((ReportModelVisitor)this);
    }

    public void visit(StepModel stepModel) {
        List attachments = stepModel.getAttachments();
        for (AttachmentModel attachment : attachments) {
            this.writeAttachment(attachment);
        }
    }

    private void writeAttachment(AttachmentModel attachment) {
        String mimeType = attachment.getMediaType();
        MediaType mediaType = MediaType.parse((String)mimeType);
        File targetFile = this.writeFile(attachment, mediaType);
        attachment.setValue(this.htmlSubDir + "/" + targetFile.getName());
        log.debug("Attachment written to " + targetFile);
    }

    private String getExtension(MediaType mediaType) {
        if (mediaType.is(MediaType.SVG_UTF_8)) {
            return "svg";
        }
        if (mediaType.is(MediaType.ICO)) {
            return "ico";
        }
        if (mediaType.is(MediaType.BMP)) {
            return "bmp";
        }
        return mediaType.subtype();
    }

    File getTargetFile(String fileName, String extension) {
        if (fileName == null) {
            fileName = "attachment";
        }
        int count = this.fileCounter.count((Object)fileName);
        this.fileCounter.add((Object)fileName);
        String suffix = "";
        if (count > 0) {
            suffix = String.valueOf(++count);
        }
        String fileNameWithExtension = fileName + suffix + "." + extension;
        while (this.usedFileNames.contains(fileNameWithExtension)) {
            this.fileCounter.add((Object)fileName);
            suffix = String.valueOf(++count);
            fileNameWithExtension = fileName + suffix + "." + extension;
        }
        this.usedFileNames.add(fileNameWithExtension);
        return new File(this.attachmentsDir, fileNameWithExtension);
    }

    private File getThumbnailFileFor(File originalImage) {
        String orgName = originalImage.getName();
        String newName = "";
        int dotIndex = orgName.lastIndexOf(".");
        if (dotIndex == -1) {
            newName = orgName + "-thumb";
        } else {
            String extension = orgName.subSequence(dotIndex + 1, orgName.length()).toString();
            newName = orgName.substring(0, dotIndex) + "-thumb." + extension;
        }
        return new File(this.attachmentsDir, newName);
    }

    private File writeFile(AttachmentModel attachment, MediaType mediaType) {
        String extension = this.getExtension(mediaType);
        File targetFile = this.getTargetFile(attachment.getFileName(), extension);
        try {
            if (attachment.isBinary()) {
                if (mediaType.is(MediaType.ANY_IMAGE_TYPE)) {
                    File thumbFile = this.getThumbnailFileFor(targetFile);
                    byte[] thumbnail = this.compressToThumbnail(attachment.getValue(), extension);
                    Files.write((byte[])thumbnail, (File)thumbFile);
                }
                Files.write((byte[])BaseEncoding.base64().decode((CharSequence)attachment.getValue()), (File)targetFile);
            } else {
                Files.write((byte[])attachment.getValue().getBytes(Charsets.UTF_8), (File)targetFile);
                if (com.tngtech.jgiven.attachment.MediaType.SVG_UTF_8.toString().equals(attachment.getMediaType())) {
                    File thumbFile = this.getThumbnailFileFor(targetFile);
                    this.writeThumbnailForSVG(targetFile, thumbFile);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while trying to write attachment to file " + targetFile, (Throwable)e);
        }
        return targetFile;
    }

    private byte[] compressToThumbnail(String base64content, String extension) {
        byte[] imageBytes = BaseEncoding.base64().decode((CharSequence)base64content);
        byte[] base64thumb = new byte[]{};
        try {
            BufferedImage before = ImageIO.read(new ByteArrayInputStream(imageBytes));
            BufferedImage after = Html5AttachmentGenerator.scaleDown(before);
            base64thumb = this.bufferedImageToBase64(after, extension);
        }
        catch (IOException e) {
            log.error("Error while decoding the attachment to BufferedImage ", (Throwable)e);
        }
        return base64thumb;
    }

    static BufferedImage scaleDown(BufferedImage before) {
        double xFactor = Math.min(1.0, 20.0 / (double)before.getWidth());
        double yFactor = Math.min(1.0, 20.0 / (double)before.getHeight());
        double factor = Math.max(xFactor, yFactor);
        int width = (int)Math.round((double)before.getWidth() * factor);
        int height = (int)Math.round((double)before.getHeight() * factor);
        BufferedImage after = new BufferedImage(width, height, 2);
        AffineTransform at = new AffineTransform();
        at.scale(factor, factor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        return scaleOp.filter(before, after);
    }

    private byte[] bufferedImageToBase64(BufferedImage bi, String extension) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] imageArray = new byte[]{};
        try {
            ImageIO.write((RenderedImage)bi, extension, baos);
            imageArray = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            log.error("Error while decoding the compressed BufferedImage to base64 ", (Throwable)e);
        }
        return imageArray;
    }

    private void writeThumbnailForSVG(File initialSVG, File thumbnailSVG) {
        String base64PNGImage = this.getPNGFromSVG(initialSVG);
        byte[] scaledDownInBytes = this.compressToThumbnail(base64PNGImage, "png");
        Dimension imageDimension = this.getImageDimension(scaledDownInBytes);
        String base64ScaledDownContent = BaseEncoding.base64().encode(scaledDownInBytes);
        this.createSVGThumbFile(thumbnailSVG, base64ScaledDownContent, imageDimension);
    }

    Dimension getImageDimension(byte[] givenImage) {
        Dimension dimension = new Dimension();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(givenImage);){
            BufferedImage image = ImageIO.read(inputStream);
            dimension.height = image.getHeight();
            dimension.width = image.getWidth();
        }
        catch (IOException e) {
            log.error("The converted png image cannot be read.");
        }
        return dimension;
    }

    void createSVGThumbFile(File targetFile, String base64Image, Dimension dimension) {
        String xmlFormat = this.getXMLFormat(base64Image, dimension);
        try (FileWriter fileWriter = new FileWriter(targetFile);){
            fileWriter.write(xmlFormat);
        }
        catch (IOException e) {
            log.error("Error writing the thumbnail svg to " + targetFile);
        }
    }

    private String getXMLFormat(String base64Image, Dimension dimension) {
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" height=\"" + dimension.getHeight() + "px\" width=\"" + dimension.getWidth() + "px\"><image height=\"100%\" width=\"100%\" xlink:href=\"data:image/png;base64, " + base64Image + "\"/></svg>";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getPNGFromSVG(File givenSVG) {
        PNGTranscoder transcoder = new PNGTranscoder();
        TranscoderInput transcoderInput = new TranscoderInput();
        TranscoderOutput transcoderOutput = new TranscoderOutput();
        try (FileInputStream inputStream = new FileInputStream(givenSVG);){
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                transcoderInput.setInputStream((InputStream)inputStream);
                transcoderOutput.setOutputStream((OutputStream)outputStream);
                transcoder.transcode(transcoderInput, transcoderOutput);
                string = BaseEncoding.base64().encode(outputStream.toByteArray());
            }
            return string;
        }
        catch (FileNotFoundException e) {
            log.error("Error while reading the initial svg file.");
        }
        catch (IOException e) {
            log.error("Error closing the {} file", (Object)givenSVG);
        }
        catch (TranscoderException e) {
            log.error("Error while transcoding the svg file to png. Is the svg formatted correctly?");
        }
        return null;
    }
}

