/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html5;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.impl.util.Version;
import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.html5.Html5AttachmentGenerator;
import com.tngtech.jgiven.report.html5.Html5ReportConfig;
import com.tngtech.jgiven.report.html5.TagFile;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Html5ReportGenerator
extends AbstractReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(Html5ReportGenerator.class);
    private static final int MAX_BATCH_SIZE = 100;
    private PrintStream fileStream;
    private MetaData metaData = new MetaData();
    private int caseCountOfCurrentBatch;
    private File dataDirectory;
    private ByteArrayOutputStream byteStream;
    private PrintStream contentStream;
    private Html5ReportConfig specializedConfig;

    public AbstractReportConfig createReportConfig(String ... args) {
        return new Html5ReportConfig(args);
    }

    public void generate() {
        this.specializedConfig = (Html5ReportConfig)this.config;
        log.info("Generating HTML5 report to {}", (Object)new File(this.specializedConfig.getTargetDir(), "index.html").getAbsoluteFile());
        this.dataDirectory = new File(this.specializedConfig.getTargetDir(), "data");
        this.metaData.title = this.specializedConfig.getTitle();
        if (!this.dataDirectory.exists() && !this.dataDirectory.mkdirs()) {
            log.error("Could not create target directory " + this.dataDirectory);
            return;
        }
        try {
            this.unzipApp(this.config.getTargetDir());
            this.createDataFiles();
            this.generateMetaData();
            this.generateTagFile();
            this.copyCustomFile(this.specializedConfig.getCustomCss(), new File(this.specializedConfig.getTargetDir(), "css"), "custom.css");
            this.copyCustomFile(this.specializedConfig.getCustomJs(), new File(this.specializedConfig.getTargetDir(), "js"), "custom.js");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void copyCustomFile(File file, File targetDirectory, String targetName) throws IOException {
        if (file != null) {
            if (!file.canRead()) {
                log.info("Cannot read " + file + ", skipping");
            } else {
                targetDirectory.mkdirs();
                if (!targetDirectory.canWrite()) {
                    String message = "Could not create directory " + targetDirectory;
                    log.error(message);
                    throw new JGivenInstallationException(message);
                }
                Files.copy((File)file, (File)new File(targetDirectory, targetName));
            }
        }
    }

    private void createDataFiles() throws IOException {
        for (ReportModelFile file : this.completeReportModel.getAllReportModels()) {
            this.handleReportModel(file.model(), file.file());
        }
        this.closeWriter();
    }

    public void handleReportModel(ReportModel model, File file) throws IOException {
        new Html5AttachmentGenerator().generateAttachments(this.dataDirectory, model);
        this.createWriter();
        if (this.caseCountOfCurrentBatch > 0) {
            this.contentStream.append(",");
        }
        this.deleteUnusedCaseSteps(model);
        this.caseCountOfCurrentBatch += this.getCaseCount(model);
        model.setTagMap(null);
        new Gson().toJson((Object)model, (Appendable)this.contentStream);
        if (this.caseCountOfCurrentBatch > 100) {
            this.closeWriter();
        }
    }

    private void deleteUnusedCaseSteps(ReportModel model) {
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            if (!scenarioModel.isCasesAsTable() || this.hasAttachment(scenarioModel)) continue;
            List cases = scenarioModel.getScenarioCases();
            for (int i = 1; i < cases.size(); ++i) {
                ScenarioCaseModel caseModel = (ScenarioCaseModel)cases.get(i);
                caseModel.setSteps(Collections.emptyList());
            }
        }
    }

    private boolean hasAttachment(ScenarioModel scenarioModel) {
        return this.hasAttachment(scenarioModel.getCase(0));
    }

    private boolean hasAttachment(ScenarioCaseModel aCase) {
        for (StepModel model : aCase.getSteps()) {
            if (!model.hasAttachment()) continue;
            return true;
        }
        return false;
    }

    private int getCaseCount(ReportModel model) {
        int count = 0;
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            count += scenarioModel.getScenarioCases().size();
        }
        return count;
    }

    private void closeWriter() throws IOException {
        if (this.fileStream != null) {
            this.contentStream.append("]}");
            this.contentStream.flush();
            ResourceUtil.close((Closeable[])new Closeable[]{this.contentStream});
            String base64String = BaseEncoding.base64().encode(this.byteStream.toByteArray());
            this.fileStream.append("'" + base64String + "'");
            this.fileStream.append(");");
            this.fileStream.flush();
            ResourceUtil.close((Closeable[])new Closeable[]{this.fileStream});
            this.fileStream = null;
            log.info("Written " + this.caseCountOfCurrentBatch + " scenarios to " + this.metaData.data.get(this.metaData.data.size() - 1));
        }
    }

    private void createWriter() {
        if (this.fileStream == null) {
            String fileName = "data" + this.metaData.data.size() + ".js";
            this.metaData.data.add(fileName);
            File targetFile = new File(this.dataDirectory, fileName);
            log.debug("Generating " + targetFile + "...");
            this.caseCountOfCurrentBatch = 0;
            try {
                this.byteStream = new ByteArrayOutputStream();
                this.contentStream = new PrintStream((OutputStream)new GZIPOutputStream(this.byteStream), false, "utf-8");
                this.contentStream.append("{\"scenarios\":[");
                this.fileStream = new PrintStream((OutputStream)new FileOutputStream(targetFile), false, "utf-8");
                this.fileStream.append("jgivenReport.addZippedScenarios(");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not open file " + targetFile + " for writing", e);
            }
        }
    }

    private void generateMetaData() throws IOException {
        File metaDataFile = new File(this.dataDirectory, "metaData.js");
        log.debug("Generating " + metaDataFile + "...");
        this.metaData.showThumbnails = this.specializedConfig.getShowThumbnails();
        String content = "jgivenReport.setMetaData(" + new Gson().toJson((Object)this.metaData) + " );";
        Files.write((CharSequence)content, (File)metaDataFile, (Charset)Charsets.UTF_8);
    }

    private void generateTagFile() throws IOException {
        File tagFile = new File(this.dataDirectory, "tags.js");
        log.debug("Generating " + tagFile + "...");
        TagFile tagFileContent = new TagFile();
        tagFileContent.fill(this.completeReportModel.getTagIdMap());
        String content = "jgivenReport.setTags(" + new Gson().toJson((Object)tagFileContent) + " );";
        Files.write((CharSequence)content, (File)tagFile, (Charset)Charsets.UTF_8);
    }

    protected void unzipApp(File toDir) throws IOException {
        ZipEntry entry;
        String appZipPath = "/" + Html5ReportGenerator.class.getPackage().getName().replace('.', '/') + "/app.zip";
        log.debug("Unzipping {}...", (Object)appZipPath);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(appZipPath);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((entry = zipInputStream.getNextEntry()) != null) {
            int len;
            File file = new File(toDir, entry.getName());
            if (!file.toPath().normalize().startsWith(toDir.toPath().normalize())) {
                throw new RuntimeException("Bad zip entry");
            }
            if (entry.isDirectory()) {
                if (file.exists()) continue;
                log.debug("Creating directory {}...", (Object)file);
                if (file.mkdirs()) continue;
                throw new IOException("Could not create directory " + file);
            }
            log.debug("Unzipping {}...", (Object)file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = zipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
            fileOutputStream.close();
        }
    }

    static class MetaData {
        Date created = new Date();
        String version = Version.VERSION.toString();
        String title = "JGiven Report";
        List<String> data = Lists.newArrayList();
        Boolean showThumbnails = true;

        MetaData() {
        }
    }
}

