/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.junit;

import com.google.common.collect.Maps;
import com.tngtech.jgiven.report.model.ReportModel;
import java.util.Map;

public class ScenarioModelHolder {
    private static final ScenarioModelHolder instance = new ScenarioModelHolder();
    private final Map<String, ReportModel> reportModels = Maps.newHashMap();

    public static ScenarioModelHolder getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportModel getReportModel(Class<?> testClass) {
        Map<String, ReportModel> map = this.reportModels;
        synchronized (map) {
            ReportModel reportModel = this.reportModels.get(testClass.getCanonicalName());
            if (reportModel == null) {
                reportModel = new ReportModel();
                reportModel.setTestClass(testClass);
                this.reportModels.put(testClass.getCanonicalName(), reportModel);
            }
            return reportModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportModel getAndRemoveReportModel(Class<?> testClass) {
        Map<String, ReportModel> map = this.reportModels;
        synchronized (map) {
            ReportModel reportModel = this.reportModels.get(testClass.getCanonicalName());
            this.reportModels.remove(testClass.getCanonicalName());
            return reportModel;
        }
    }
}

