/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.junit5;

import com.tngtech.jgiven.base.ScenarioTestBase;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.impl.Scenario;
import com.tngtech.jgiven.impl.ScenarioBase;
import com.tngtech.jgiven.impl.ScenarioHolder;
import com.tngtech.jgiven.impl.util.ThrowableUtil;
import com.tngtech.jgiven.junit5.ArgumentReflectionUtil;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModel;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Optional;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class JGivenExtension
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"com.tngtech.jgiven"});
    private static final String REPORT_MODEL = "report-model";

    public void beforeAll(ExtensionContext context) {
        this.validatePerMethodLifecycle(context);
        ReportModel reportModel = new ReportModel();
        reportModel.setTestClass((Class)context.getTestClass().orElseThrow());
        if (!context.getDisplayName().equals(((Class)context.getTestClass().orElseThrow()).getSimpleName())) {
            reportModel.setName(context.getDisplayName());
        }
        context.getStore(NAMESPACE).put((Object)REPORT_MODEL, (Object)reportModel);
        AbstractJGivenConfiguration configuration = ConfigurationUtil.getConfiguration((Class)((Class)context.getTestClass().get()));
        if (configuration.getTagConfiguration(Tag.class) == null) {
            configuration.configureTag(Tag.class).description("JUnit 5 Tag").color("orange");
        }
    }

    public void afterAll(ExtensionContext context) {
        ScenarioHolder.get().removeScenarioOfCurrentThread();
        new CommonReportHelper().finishReport((ReportModel)context.getStore(NAMESPACE).get((Object)REPORT_MODEL));
    }

    public void beforeEach(ExtensionContext context) {
        this.getScenario().startScenario((Class)context.getTestClass().orElseThrow(), (Method)context.getTestMethod().orElseThrow(), ArgumentReflectionUtil.getNamedArgs(context));
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        ScenarioBase scenario = this.getScenario();
        try {
            this.reportPotentialExecutionException(scenario, context);
            scenario.finished();
            Assumptions.assumeTrue((boolean)EnumSet.of(ExecutionStatus.SUCCESS, ExecutionStatus.FAILED, ExecutionStatus.ABORTED).contains(scenario.getScenarioModel().getExecutionStatus()));
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            ScenarioHolder.get().removeScenarioOfCurrentThread();
        }
    }

    private void reportPotentialExecutionException(ScenarioBase scenario, ExtensionContext context) {
        Optional exception = context.getExecutionException();
        if (exception.isEmpty()) {
            return;
        }
        if (ThrowableUtil.isAssumptionException((Throwable)((Throwable)exception.get()))) {
            scenario.getExecutor().aborted((Throwable)exception.get());
        } else if (!ThrowableUtil.isAssumptionException((Throwable)((Throwable)exception.get()))) {
            scenario.getExecutor().failed((Throwable)exception.get());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        Scenario scenario;
        ScenarioBase currentScenario = ScenarioHolder.get().getScenarioOfCurrentThread();
        if (testInstance instanceof ScenarioTestBase) {
            scenario = ((ScenarioTestBase)testInstance).getScenario();
        } else {
            ScenarioBase scenarioBase = scenario = currentScenario == null ? new ScenarioBase() : currentScenario;
        }
        if (scenario != currentScenario) {
            ReportModel reportModel = (ReportModel)context.getStore(NAMESPACE).get((Object)REPORT_MODEL);
            scenario.setModel(reportModel);
            ScenarioHolder.get().setScenarioOfCurrentThread((ScenarioBase)scenario);
        }
        scenario.getExecutor().injectStages(testInstance);
        scenario.getExecutor().readScenarioState(testInstance);
    }

    private void validatePerMethodLifecycle(ExtensionContext context) {
        if (this.isPerClassLifecycle(context)) {
            throw new JGivenWrongUsageException("JGiven does not support keeping a test instance over multiple scenarios. Please use Lifecycle '" + String.valueOf(TestInstance.Lifecycle.PER_METHOD) + "'.");
        }
    }

    private boolean isPerClassLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().filter(lifecycle -> TestInstance.Lifecycle.PER_CLASS == lifecycle).isPresent();
    }

    private ScenarioBase getScenario() {
        return ScenarioHolder.get().getScenarioOfCurrentThread();
    }
}

