/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.maven;

import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.ReportGenerator;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportConfig;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportGenerator;
import com.tngtech.jgiven.report.html5.Html5ReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="report", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class JGivenReportMojo
extends AbstractMojo {
    public static final String JGIVEN = "JGiven ";
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/jgiven-reports/json")
    private File sourceDirectory;
    @Parameter(defaultValue="src/test/resources/jgiven/custom.css")
    private File customCssFile;
    @Parameter(defaultValue="src/test/resources/jgiven/custom.js")
    private File customJsFile;
    @Parameter(defaultValue="html")
    private String format;
    @Parameter(defaultValue="JGiven Report")
    private String title;
    @Parameter(defaultValue="false")
    boolean excludeEmptyScenarios;
    @Parameter(defaultValue="true")
    boolean thumbnailsAreShown;

    public JGivenReportMojo() {
    }

    public JGivenReportMojo(File buildDirectory, File outputDirectory, File sourceDirectory, File customCssFile, File customJsFile, String format, String title, boolean excludeEmptyScenarios, boolean thumbnailsAreShown) {
        this.buildDirectory = buildDirectory;
        this.outputDirectory = outputDirectory;
        this.sourceDirectory = sourceDirectory;
        this.customCssFile = customCssFile;
        this.customJsFile = customJsFile;
        this.format = format;
        this.title = title;
        this.excludeEmptyScenarios = excludeEmptyScenarios;
        this.thumbnailsAreShown = thumbnailsAreShown;
    }

    public void execute() throws MojoExecutionException {
        ReportGenerator.Format parsedFormat = ReportGenerator.Format.fromStringOrNull((String)this.format);
        this.selectOutputDirectory(parsedFormat);
        try {
            AsciiDocReportConfig config;
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Error while trying to create output directory " + this.outputDirectory);
            }
            this.getLog().info((CharSequence)(JGIVEN + parsedFormat + " report source directory: " + this.sourceDirectory));
            this.getLog().info((CharSequence)(JGIVEN + parsedFormat + " report output directory: " + this.outputDirectory));
            if (this.customCssFile != null && this.customCssFile.exists()) {
                this.getLog().info((CharSequence)(JGIVEN + parsedFormat + " report custom CSS file: " + this.customCssFile));
            }
            if (this.customJsFile != null && this.customJsFile.exists()) {
                this.getLog().info((CharSequence)(JGIVEN + parsedFormat + " report custom JS file: " + this.customJsFile));
            }
            this.getLog().info((CharSequence)("Generating " + parsedFormat + " reports to " + this.outputDirectory + "..."));
            AsciiDocReportGenerator generator = switch (parsedFormat) {
                case ReportGenerator.Format.ASCIIDOC -> {
                    config = new AsciiDocReportConfig();
                    yield new AsciiDocReportGenerator();
                }
                case ReportGenerator.Format.TEXT -> {
                    config = new PlainTextReportConfig();
                    yield new PlainTextReportGenerator();
                }
                default -> {
                    Html5ReportConfig customConf = new Html5ReportConfig();
                    customConf.setShowThumbnails(this.thumbnailsAreShown);
                    customConf.setCustomCss(this.customCssFile);
                    customConf.setCustomJs(this.customJsFile);
                    config = customConf;
                    yield ReportGenerator.generateHtml5Report();
                }
            };
            config.setTitle(this.title);
            config.setSourceDir(this.sourceDirectory);
            config.setTargetDir(this.outputDirectory);
            config.setExcludeEmptyScenarios(Boolean.valueOf(this.excludeEmptyScenarios));
            generator.generateWithConfig((AbstractReportConfig)config);
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
            this.getLog().info((CharSequence)("Generated JGiven " + parsedFormat + " reports to directory " + this.outputDirectory));
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while trying to generate " + parsedFormat + " reports", e);
        }
    }

    private void selectOutputDirectory(ReportGenerator.Format parsedFormat) {
        if (this.outputDirectory != null) {
            return;
        }
        switch (parsedFormat) {
            case HTML: 
            case HTML5: {
                this.outputDirectory = new File(this.buildDirectory, "/jgiven-reports/html");
                break;
            }
            case ASCIIDOC: {
                this.outputDirectory = new File(this.buildDirectory, "/jgiven-reports/asciidoc");
                break;
            }
            case TEXT: {
                this.outputDirectory = new File(this.buildDirectory, "/jgiven-reports/text");
            }
        }
    }
}

