/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.integration.spring;

import com.tngtech.jgiven.impl.ByteBuddyStageClassCreator;
import com.tngtech.jgiven.impl.CachingStageClassCreator;
import com.tngtech.jgiven.impl.DefaultStageCreator;
import com.tngtech.jgiven.impl.StageClassCreator;
import com.tngtech.jgiven.impl.intercept.StepInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class SpringStageCreator
extends DefaultStageCreator {
    private static final Logger log = LoggerFactory.getLogger(SpringStageCreator.class);
    private static final CachingStageClassCreator fallBackStageClassCreator = new CachingStageClassCreator((StageClassCreator)new ByteBuddyStageClassCreator());
    @Autowired
    private ApplicationContext applicationContext;

    public SpringStageCreator() {
        super((StageClassCreator)fallBackStageClassCreator);
    }

    public <T> T createStage(Class<T> stageClass, StepInterceptor stepInterceptor) {
        try {
            Object bean = this.applicationContext.getBean(stageClass);
            this.setStepInterceptor(bean, stepInterceptor);
            return (T)bean;
        }
        catch (NoSuchBeanDefinitionException nbe) {
            return (T)super.createStage(stageClass, stepInterceptor);
        }
        catch (ClassCastException cce) {
            log.warn("Class " + ClassUtils.getShortName(stageClass) + " is not annotated with @JGivenStage. Falling back to default JGiven proxy. Spring features will not be supported for this stage instance.", (Throwable)cce);
            return (T)super.createStage(stageClass, stepInterceptor);
        }
        catch (Exception e) {
            log.error("Error while trying to get the Spring bean for stage class " + String.valueOf(stageClass), (Throwable)e);
            return null;
        }
    }
}

