/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.testng;

import com.tngtech.jgiven.base.ScenarioTestBase;
import com.tngtech.jgiven.exception.FailIfPassedException;
import com.tngtech.jgiven.impl.ScenarioBase;
import com.tngtech.jgiven.impl.ScenarioHolder;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.ParameterNameUtil;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ScenarioTestListener
implements ITestListener {
    public static final String SCENARIO_ATTRIBUTE = "jgiven::scenario";
    public static final String REPORT_MODELS_ATTRIBUTE = "jgiven::reportModels";

    public void onTestStart(ITestResult paramITestResult) {
        ScenarioBase scenario;
        Object instance = paramITestResult.getInstance();
        if (instance instanceof ScenarioTestBase) {
            ScenarioTestBase testInstance = (ScenarioTestBase)instance;
            scenario = testInstance.createNewScenario();
        } else {
            scenario = new ScenarioBase();
        }
        ScenarioHolder.get().setScenarioOfCurrentThread(scenario);
        paramITestResult.setAttribute(SCENARIO_ATTRIBUTE, (Object)scenario);
        ReportModel reportModel = this.getReportModel(paramITestResult, instance.getClass());
        scenario.setModel(reportModel);
        scenario.getExecutor().setSuppressStepExceptions(false);
        scenario.getExecutor().setSuppressExceptions(true);
        scenario.getExecutor().injectStages(instance);
        Method method = paramITestResult.getMethod().getConstructorOrMethod().getMethod();
        scenario.startScenario(instance.getClass(), method, this.getArgumentsFrom(method, paramITestResult));
        scenario.getExecutor().readScenarioState(instance);
    }

    private ScenarioBase getScenario(ITestResult paramITestResult) {
        return (ScenarioBase)paramITestResult.getAttribute(SCENARIO_ATTRIBUTE);
    }

    private ReportModel getReportModel(ITestResult testResult, Class<?> clazz) {
        ConcurrentHashMap<String, ReportModel> reportModels = this.getReportModels(testResult.getTestContext());
        ReportModel model = reportModels.get(clazz.getName());
        if (model == null) {
            model = new ReportModel();
            model.setTestClass(clazz);
            ReportModel previousModel = reportModels.putIfAbsent(clazz.getName(), model);
            if (previousModel != null) {
                model = previousModel;
            }
        }
        AssertionUtil.assertNotNull((Object)model, (String)"Report model is null");
        return model;
    }

    public void onTestSuccess(ITestResult paramITestResult) {
        this.testFinished(paramITestResult);
    }

    public void onTestFailure(ITestResult paramITestResult) {
        ScenarioBase scenario = this.getScenario(paramITestResult);
        if (scenario != null) {
            scenario.getExecutor().failed(paramITestResult.getThrowable());
            this.testFinished(paramITestResult);
        }
    }

    public void onTestSkipped(ITestResult testResult) {
    }

    private void testFinished(ITestResult testResult) {
        try {
            ScenarioBase scenario = this.getScenario(testResult);
            scenario.finished();
        }
        catch (FailIfPassedException ex) {
            testResult.setStatus(2);
            testResult.setThrowable((Throwable)ex);
            testResult.getTestContext().getPassedTests().removeResult(testResult);
            testResult.getTestContext().getFailedTests().addResult(testResult, testResult.getMethod());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            ScenarioHolder.get().removeScenarioOfCurrentThread();
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult paramITestResult) {
    }

    public void onStart(ITestContext paramITestContext) {
        paramITestContext.setAttribute(REPORT_MODELS_ATTRIBUTE, new ConcurrentHashMap());
    }

    public void onFinish(ITestContext paramITestContext) {
        ConcurrentHashMap<String, ReportModel> reportModels = this.getReportModels(paramITestContext);
        for (ReportModel reportModel : reportModels.values()) {
            new CommonReportHelper().finishReport(reportModel);
        }
    }

    private ConcurrentHashMap<String, ReportModel> getReportModels(ITestContext paramITestContext) {
        return (ConcurrentHashMap)paramITestContext.getAttribute(REPORT_MODELS_ATTRIBUTE);
    }

    private List<NamedArgument> getArgumentsFrom(Method method, ITestResult paramITestResult) {
        return ParameterNameUtil.mapArgumentsWithParameterNames((AccessibleObject)method, Arrays.asList(paramITestResult.getParameters()));
    }
}

