/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.testng;

import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.util.Arrays;
import java.util.Optional;
import org.testng.ITestResult;
import org.testng.annotations.Test;

class IncompatibleMultithreadingChecker {
    IncompatibleMultithreadingChecker() {
    }

    public void checkIncompatibleMultiThreading(ITestResult paramITestResult) {
        boolean isMultiThreaded = this.isMultiThreaded(paramITestResult.getTestClass().getRealClass());
        boolean hasInjectedStages = this.hasInjectedStages(paramITestResult.getTestClass().getRealClass());
        if (isMultiThreaded && hasInjectedStages) {
            throw new JGivenWrongUsageException("JGiven does not support using multi-threading and stage injection in TestNG at the same time due to their different lifecycle models. Please switch to single threaded execution or provide stages via inheriting from ScenarioTest");
        }
    }

    private boolean isMultiThreaded(Class<?> testClass) {
        return Optional.ofNullable(testClass.getAnnotation(Test.class)).map(test -> !test.singleThreaded()).orElse(false);
    }

    private boolean hasInjectedStages(Class<?> testClass) {
        InjectedStageFinder injectedStageFinder = new InjectedStageFinder();
        ReflectionUtil.forEachSuperClass(testClass, (ReflectionUtil.ClassAction)injectedStageFinder);
        return injectedStageFinder.foundInjectedStage;
    }

    private static class InjectedStageFinder
    implements ReflectionUtil.ClassAction {
        private boolean foundInjectedStage = false;

        private InjectedStageFinder() {
        }

        public void act(Class<?> clazz) {
            this.foundInjectedStage = this.foundInjectedStage || this.thisClassDeclaresInjectedFields(clazz);
        }

        private boolean thisClassDeclaresInjectedFields(Class<?> clazz) {
            return Arrays.stream(clazz.getDeclaredFields()).anyMatch(field -> field.isAnnotationPresent(ScenarioStage.class));
        }
    }
}

