/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.convert.ConverterContext;
import com.tngtech.junit.dataprovider.convert.DataConverter;
import com.tngtech.junit.dataprovider.placeholder.ArgumentPlaceholder;
import com.tngtech.junit.dataprovider.placeholder.BasePlaceholder;
import com.tngtech.junit.dataprovider.placeholder.CanonicalClassNamePlaceholder;
import com.tngtech.junit.dataprovider.placeholder.CompleteMethodSignaturePlaceholder;
import com.tngtech.junit.dataprovider.placeholder.IndexPlaceholder;
import com.tngtech.junit.dataprovider.placeholder.NamedArgumentPlaceholder;
import com.tngtech.junit.dataprovider.placeholder.SimpleClassNamePlaceholder;
import com.tngtech.junit.dataprovider.placeholder.SimpleMethodNamePlaceholder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;

abstract class AbstractDataProviderInvocationContextProvider<TEST_ANNOTATION extends Annotation>
implements TestTemplateInvocationContextProvider {
    private final DataConverter dataConverter;
    private final Class<TEST_ANNOTATION> testAnnotationClass;

    protected AbstractDataProviderInvocationContextProvider(Class<TEST_ANNOTATION> testAnnotationClass, DataConverter dataConverter) {
        this.testAnnotationClass = testAnnotationClass;
        this.dataConverter = dataConverter;
    }

    protected AbstractDataProviderInvocationContextProvider(Class<TEST_ANNOTATION> testAnnotationClass) {
        this(testAnnotationClass, new DataConverter());
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return context.getTestMethod().filter(m -> AnnotationSupport.isAnnotated((AnnotatedElement)m, this.testAnnotationClass)).isPresent();
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        return AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, this.testAnnotationClass).map(annotation -> this.provideInvocationContexts(context, annotation)).orElseThrow(() -> new ExtensionConfigurationException(String.format("Could not find annotation '%s' on test method '%s'.", this.testAnnotationClass, testMethod)));
    }

    protected abstract Stream<TestTemplateInvocationContext> provideInvocationContexts(ExtensionContext var1, TEST_ANNOTATION var2);

    protected List<? extends BasePlaceholder> getDefaultPlaceholders() {
        ArrayList<BasePlaceholder> result = new ArrayList<BasePlaceholder>();
        result.add(new ArgumentPlaceholder());
        result.add(new CanonicalClassNamePlaceholder());
        result.add(new CompleteMethodSignaturePlaceholder());
        result.add(new IndexPlaceholder());
        result.add(new NamedArgumentPlaceholder());
        result.add(new SimpleClassNamePlaceholder());
        result.add(new SimpleMethodNamePlaceholder());
        return result;
    }

    protected Stream<List<Object>> convertData(Method testMethod, Object data, ConverterContext context) {
        Preconditions.checkNotNull(testMethod, "'testMethod' must not be null");
        Preconditions.checkNotNull(data, "'data' must not be null");
        Preconditions.checkNotNull(context, "'context' must not be null");
        return this.dataConverter.convert(data, testMethod.isVarArgs(), testMethod.getParameterTypes(), context).stream().map(Arrays::asList);
    }
}

