/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.Preconditions;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class DataProviderParameterResolver
implements ParameterResolver {
    private final List<Object> arguments;

    DataProviderParameterResolver(List<Object> arguments) {
        this.arguments = new ArrayList<Object>((Collection)Preconditions.checkNotNull(arguments, "'arguments' must not be null"));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Method testMethod;
        Executable declaringExecutable = parameterContext.getParameter().getDeclaringExecutable();
        return declaringExecutable.equals(testMethod = (Method)extensionContext.getTestMethod().orElse(null)) && parameterContext.getIndex() < this.arguments.size();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.arguments.get(parameterContext.getIndex());
    }
}

