/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.format.DataProviderTestNameFormatter;
import com.tngtech.junit.dataprovider.placeholder.BasePlaceholder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DisplayNameContext {
    private final Class<? extends DataProviderTestNameFormatter> formatter;
    private final String format;
    private final List<? extends BasePlaceholder> placeholders;

    public DisplayNameContext(String format, List<? extends BasePlaceholder> placeholders) {
        this(null, format, placeholders);
    }

    public DisplayNameContext(Class<? extends DataProviderTestNameFormatter> formatter, String format, List<? extends BasePlaceholder> placeholders) {
        this.formatter = formatter;
        this.format = Preconditions.checkNotNull(format, "'format' must not be null");
        this.placeholders = new ArrayList<BasePlaceholder>((Collection)Preconditions.checkNotNull(placeholders, "'placeholders' must not be null"));
    }

    public Class<? extends DataProviderTestNameFormatter> getFormatter() {
        return this.formatter;
    }

    public String getFormat() {
        return this.format;
    }

    public List<? extends BasePlaceholder> getPlaceholders() {
        return Collections.unmodifiableList(this.placeholders);
    }
}

