/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.resolver;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.resolver.DataProviderMethodResolver;
import com.tngtech.junit.dataprovider.resolver.DataProviderResolverContext;
import com.tngtech.junit.dataprovider.resolver.ResolveStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DataProviderMethodResolverHelper {
    public static List<Method> findDataProviderMethods(DataProviderResolverContext context) {
        Preconditions.checkNotNull(context, "'context' must not be null");
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<? extends DataProviderMethodResolver> resolverClass : context.getResolverClasses()) {
            DataProviderMethodResolver resolver = DataProviderMethodResolverHelper.newInstance(resolverClass);
            List<Method> dataProviderMethods = resolver.resolve(context);
            if (context.getResolveStrategy() == ResolveStrategy.UNTIL_FIRST_MATCH && !dataProviderMethods.isEmpty()) {
                result.addAll(dataProviderMethods);
                break;
            }
            if (context.getResolveStrategy() != ResolveStrategy.AGGREGATE_ALL_MATCHES) continue;
            result.addAll(dataProviderMethods);
        }
        return result;
    }

    private static <T> T newInstance(Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Could not find default constructor to instantiate '%s'.", clazz), e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(String.format("Security violation while trying to access default constructor to instantiate '%s'.", clazz), e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not access default constructor to instantiate '%s'.", clazz), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Could not instantiate '%s' using default constructor.", clazz), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("The default constructor of '%s' has thrown an exception: %s", clazz, e.getMessage()), e);
        }
    }
}

