/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.resolver;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.resolver.DataProviderMethodResolver;
import com.tngtech.junit.dataprovider.resolver.ResolveStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DataProviderResolverContext {
    public static final String METHOD_NAME_TO_USE_CONVENTION = "<use_convention>";
    private final Method testMethod;
    private final List<Class<? extends DataProviderMethodResolver>> resolverClasses;
    private final ResolveStrategy resolveStrategy;
    private final List<Class<?>> locations;
    private final Class<? extends Annotation> dataProviderAnnotationClass;
    private final String dataProviderName;

    public static List<Class<?>> generateLocations(Class<?> testClass, Class<?> ... explicitLocations) {
        Preconditions.checkNotNull(testClass, "'testClass' must not be null");
        if (explicitLocations == null || explicitLocations.length == 0) {
            List<Class<?>> result = Collections.singletonList(testClass);
            return result;
        }
        return Arrays.asList(explicitLocations);
    }

    public DataProviderResolverContext(Method testMethod, List<Class<? extends DataProviderMethodResolver>> resolverClasses, ResolveStrategy resolveStrategy, List<Class<?>> locations, Class<? extends Annotation> dataProviderAnnotationClass, String dataProviderName) {
        this.testMethod = Preconditions.checkNotNull(testMethod, "'testMethod' must not be null");
        this.resolverClasses = new ArrayList<Class<? extends DataProviderMethodResolver>>((Collection)Preconditions.checkNotNull(resolverClasses, "'resolverClasses' must not be null"));
        this.resolveStrategy = Preconditions.checkNotNull(resolveStrategy, "'resolveStrategy' must not be null");
        Preconditions.checkNotNull(locations, "'locations' must not be null");
        this.locations = locations.isEmpty() ? Collections.singletonList(testMethod.getDeclaringClass()) : new ArrayList(locations);
        this.dataProviderAnnotationClass = Preconditions.checkNotNull(dataProviderAnnotationClass, "'dataProviderAnnotationClass' must not be null");
        this.dataProviderName = Preconditions.checkNotNull(dataProviderName, "'dataProviderName' must not be null");
    }

    public boolean useDataProviderNameConvention() {
        return METHOD_NAME_TO_USE_CONVENTION.equals(this.dataProviderName);
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public List<Class<? extends DataProviderMethodResolver>> getResolverClasses() {
        return Collections.unmodifiableList(this.resolverClasses);
    }

    public ResolveStrategy getResolveStrategy() {
        return this.resolveStrategy;
    }

    public List<Class<?>> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public Class<? extends Annotation> getDataProviderAnnotationClass() {
        return this.dataProviderAnnotationClass;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }
}

