/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.resolver;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.resolver.DataProviderMethodResolver;
import com.tngtech.junit.dataprovider.resolver.DataProviderResolverContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DefaultDataProviderMethodResolver
implements DataProviderMethodResolver {
    @Override
    public List<Method> resolve(DataProviderResolverContext context) {
        Preconditions.checkNotNull(context, "'context' must not be null");
        List<Method> dataProviderMethods = this.findAnnotatedMethods(context.getLocations(), context.getDataProviderAnnotationClass());
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method dataProviderMethod : dataProviderMethods) {
            if (context.useDataProviderNameConvention()) {
                if (!this.isMatchingNameConvention(context.getTestMethod().getName(), dataProviderMethod.getName())) continue;
                result.add(dataProviderMethod);
                continue;
            }
            if (!dataProviderMethod.getName().equals(context.getDataProviderName())) continue;
            result.add(dataProviderMethod);
        }
        return result;
    }

    protected List<Method> findAnnotatedMethods(List<Class<?>> locations, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> location : locations) {
            ArrayList<Method> intermediateResult = new ArrayList<Method>();
            for (Class<?> currentClass = location; currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Method method : this.sorted(currentClass.getDeclaredMethods())) {
                    Annotation foundAnnotation = method.getAnnotation(annotationClass);
                    if (foundAnnotation == null || this.isMethodShadowedBy(method, intermediateResult)) continue;
                    intermediateResult.add(method);
                }
            }
            result.addAll(intermediateResult);
        }
        return result;
    }

    protected boolean isMatchingNameConvention(String testMethodName, String dataProviderMethodName) {
        if (dataProviderMethodName.equals(testMethodName)) {
            return true;
        }
        if (dataProviderMethodName.equals(testMethodName.replaceAll("^test", "dataProvider"))) {
            return true;
        }
        if (dataProviderMethodName.equals(testMethodName.replaceAll("^test", "data"))) {
            return true;
        }
        if (dataProviderMethodName.equals("dataProvider" + Character.toUpperCase(testMethodName.charAt(0)) + testMethodName.substring(1))) {
            return true;
        }
        return dataProviderMethodName.equals("data" + Character.toUpperCase(testMethodName.charAt(0)) + testMethodName.substring(1));
    }

    private Method[] sorted(Method[] methods) {
        Comparator<Method> defaultSorter = new Comparator<Method>(){

            @Override
            public int compare(Method method1, Method method2) {
                int comparison;
                String name1 = method1.getName();
                String name2 = method2.getName();
                int n = name1.hashCode() < name2.hashCode() ? -1 : (comparison = name1.hashCode() == name2.hashCode() ? 0 : 1);
                if (comparison == 0 && (comparison = name1.compareTo(name2)) == 0) {
                    comparison = method1.toString().compareTo(method2.toString());
                }
                return comparison;
            }
        };
        Method[] result = Arrays.copyOf(methods, methods.length);
        Arrays.sort(result, defaultSorter);
        return result;
    }

    private boolean isMethodShadowedBy(Method method, List<Method> methods) {
        for (Method other : methods) {
            if (!other.getName().equals(method.getName()) || !Arrays.equals(other.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

