/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.api;

import io.jsonwebtoken.ClaimJwtException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TokenConfig {
    private static final Pattern ISSUER_PATH_PATTERN = Pattern.compile("^.*?/realms/([^/]+)$");
    @Nonnull
    private final Set<String> audience;
    @Nonnull
    private final String authorizedParty;
    @Nonnull
    private final String subject;
    @Nonnull
    private final String scope;
    @Nonnull
    private final Map<String, Object> claims;
    @Nonnull
    private final Access realmAccess;
    @Nonnull
    private final Map<String, Access> resourceAccess;
    @Nonnull
    private final Instant issuedAt;
    @Nonnull
    private final Instant authenticationTime;
    @Nonnull
    private final Instant expiration;
    private final boolean generateUserDataFromSubject;
    @Nullable
    private final Instant notBefore;
    @Nullable
    private final String hostname;
    @Nullable
    private final String realm;
    @Nullable
    private final String name;
    @Nullable
    private final String givenName;
    @Nullable
    private final String familyName;
    @Nullable
    private final String email;
    @Nullable
    private final String preferredUsername;
    @Nullable
    private final String authenticationContextClassReference;

    private TokenConfig(@Nonnull Builder builder) {
        this.audience = builder.audience.isEmpty() ? Collections.singleton("server") : builder.audience;
        this.authorizedParty = builder.authorizedParty;
        this.subject = builder.subject;
        this.generateUserDataFromSubject = builder.generateUserDataFromSubject;
        this.scope = String.join((CharSequence)" ", builder.scope);
        this.claims = builder.claims;
        this.realmAccess = builder.realmRoles;
        this.resourceAccess = builder.resourceAccess;
        this.issuedAt = builder.issuedAt;
        this.authenticationTime = builder.authenticationTime;
        this.expiration = builder.expiration;
        this.hostname = builder.hostname;
        this.realm = builder.realm;
        this.notBefore = builder.notBefore;
        this.givenName = builder.givenName;
        this.familyName = builder.familyName;
        this.name = builder.name != null ? builder.name : (this.givenName != null ? (this.familyName != null ? this.givenName + " " + this.familyName : this.givenName) : this.familyName);
        this.email = builder.email;
        this.preferredUsername = builder.preferredUsername;
        this.authenticationContextClassReference = builder.authenticationContextClassReference;
    }

    @Nonnull
    public static Builder aTokenConfig() {
        return new Builder();
    }

    @Nonnull
    public Set<String> getAudience() {
        return Collections.unmodifiableSet(this.audience);
    }

    @Nonnull
    public String getAuthorizedParty() {
        return this.authorizedParty;
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    public boolean isGenerateUserDataFromSubject() {
        return this.generateUserDataFromSubject;
    }

    @Nonnull
    public String getScope() {
        return this.scope;
    }

    @Nonnull
    public Map<String, Object> getClaims() {
        return Collections.unmodifiableMap(this.claims);
    }

    @Nonnull
    public Access getRealmAccess() {
        return this.realmAccess;
    }

    @Nonnull
    public Map<String, Access> getResourceAccess() {
        return Collections.unmodifiableMap(this.resourceAccess);
    }

    @Nonnull
    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    @Nonnull
    public Instant getAuthenticationTime() {
        return this.authenticationTime;
    }

    @Nonnull
    public Instant getExpiration() {
        return this.expiration;
    }

    @Nullable
    public Instant getNotBefore() {
        return this.notBefore;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getGivenName() {
        return this.givenName;
    }

    @Nullable
    public String getFamilyName() {
        return this.familyName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Nullable
    public String getAuthenticationContextClassReference() {
        return this.authenticationContextClassReference;
    }

    public static final class Builder {
        @Nonnull
        private final Set<String> audience = new HashSet<String>();
        @Nonnull
        private String authorizedParty = "client";
        @Nonnull
        private String subject = "user";
        @Nonnull
        private final Set<String> scope = new HashSet<String>();
        @Nonnull
        private final Map<String, Object> claims = new HashMap<String, Object>();
        @Nonnull
        private final Access realmRoles = new Access();
        @Nonnull
        private final Map<String, Access> resourceAccess = new HashMap<String, Access>();
        @Nonnull
        private Instant issuedAt = Instant.now();
        @Nonnull
        private Instant expiration = this.issuedAt.plus(10L, ChronoUnit.HOURS);
        @Nonnull
        private Instant authenticationTime = Instant.now();
        private boolean generateUserDataFromSubject = false;
        @Nullable
        private Instant notBefore;
        @Nullable
        private String hostname;
        @Nullable
        private String realm;
        @Nullable
        private String givenName;
        @Nullable
        private String familyName;
        @Nullable
        private String name;
        @Nullable
        private String email;
        @Nullable
        private String preferredUsername;
        @Nullable
        private String authenticationContextClassReference;

        private Builder() {
        }

        @Nonnull
        public Builder withSourceToken(@Nonnull String originalToken) {
            Claims untrustedClaims;
            int i = originalToken.lastIndexOf(46);
            String untrustedJwtString = originalToken.substring(0, i + 1);
            try {
                untrustedClaims = (Claims)Jwts.parserBuilder().build().parseClaimsJwt(untrustedJwtString).getBody();
            }
            catch (ClaimJwtException e) {
                untrustedClaims = e.getClaims();
            }
            block41: for (Map.Entry entry : untrustedClaims.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "aud": {
                        Object aud = entry.getValue();
                        if (aud instanceof String) {
                            this.withAudience((String)aud);
                            continue block41;
                        }
                        if (!(aud instanceof Collection)) continue block41;
                        this.withAudiences((Collection)aud);
                        continue block41;
                    }
                    case "azp": {
                        this.withAuthorizedParty(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "sub": {
                        this.withSubject(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "name": {
                        this.withName(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "given_name": {
                        this.withGivenName(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "family_name": {
                        this.withFamilyName(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "email": {
                        this.withEmail(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "preferred_username": {
                        this.withPreferredUsername(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "realm_access": {
                        Map sourceRealmAccess = this.getTypedValue(entry, Map.class);
                        this.withRealmRoles((Collection)sourceRealmAccess.get("roles"));
                        continue block41;
                    }
                    case "resource_access": {
                        Map sourceResourceAccess = this.getTypedValue(entry, Map.class);
                        sourceResourceAccess.forEach((key, value) -> this.withResourceRoles((String)key, (Collection)value.get("roles")));
                        continue block41;
                    }
                    case "scope": {
                        this.withScopes(Arrays.asList(this.getTypedValue(entry, String.class).split(" ")));
                        continue block41;
                    }
                    case "acr": {
                        this.withAuthenticationContextClassReference(this.getTypedValue(entry, String.class));
                        continue block41;
                    }
                    case "typ": {
                        if ("Bearer".equals(this.getTypedValue(entry, String.class))) continue block41;
                        throw new IllegalArgumentException("Only bearer tokens are allowed here!");
                    }
                    case "iss": {
                        String issuer = this.getTypedValue(entry, String.class);
                        try {
                            URI issuerUrl = new URI(issuer);
                            this.withHostname(issuerUrl.getHost());
                            this.withRealm(this.getRealm(issuerUrl));
                            continue block41;
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("Issuer '" + issuer + "' is not a valid URL", e);
                        }
                    }
                    case "iat": 
                    case "nbf": 
                    case "exp": 
                    case "auth_time": {
                        continue block41;
                    }
                }
                this.withClaim((String)entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Nonnull
        private <T> T getTypedValue(@Nonnull Map.Entry<String, Object> entry, @Nonnull Class<T> clazz) {
            if (clazz.isInstance(entry.getValue())) {
                return (T)entry.getValue();
            }
            throw new IllegalArgumentException(String.format("Expected %s for key %s, but found %s", clazz, entry.getKey(), entry.getValue().getClass()));
        }

        @Nonnull
        private String getRealm(@Nonnull URI issuer) {
            Matcher matcher = ISSUER_PATH_PATTERN.matcher(issuer.getPath());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("The issuer '" + issuer + "' did not conform to the expected format 'http[s]://$HOSTNAME[:$PORT][/$CONTEXT_PATH]/realms/$REALM'.");
            }
            return matcher.group(1);
        }

        @Nonnull
        public Builder withAudience(@Nonnull String audience) {
            this.audience.add(Objects.requireNonNull(audience));
            return this;
        }

        @Nonnull
        public Builder withAudiences(@Nonnull Collection<String> audiences) {
            this.audience.addAll(Objects.requireNonNull(audiences));
            return this;
        }

        @Nonnull
        public Builder withAuthorizedParty(@Nonnull String authorizedParty) {
            this.authorizedParty = Objects.requireNonNull(authorizedParty);
            return this;
        }

        @Nonnull
        public Builder withSubject(@Nonnull String subject) {
            this.subject = Objects.requireNonNull(subject);
            return this;
        }

        @Nonnull
        public Builder withSubjectAndGeneratedUserData(@Nonnull String subject) {
            this.subject = Objects.requireNonNull(subject);
            this.generateUserDataFromSubject = true;
            return this;
        }

        @Nonnull
        public Builder withScope(@Nonnull String scope) {
            this.scope.add(scope);
            return this;
        }

        @Nonnull
        public Builder withScopes(@Nonnull Collection<String> scopes) {
            this.scope.addAll(scopes);
            return this;
        }

        @Nonnull
        public Builder withHostname(@Nonnull String hostname) {
            this.hostname = Objects.requireNonNull(hostname);
            return this;
        }

        @Nonnull
        public Builder withRealm(@Nonnull String realm) {
            this.realm = Objects.requireNonNull(realm);
            return this;
        }

        @Nonnull
        public Builder withRealmRoles(@Nonnull Collection<String> roles) {
            this.realmRoles.addRoles(Objects.requireNonNull(roles));
            return this;
        }

        @Nonnull
        public Builder withRealmRole(@Nonnull String role) {
            this.realmRoles.addRole(Objects.requireNonNull(role));
            return this;
        }

        @Nonnull
        public Builder withResourceRoles(@Nonnull String resource, @Nonnull Collection<String> roles) {
            this.resourceAccess.computeIfAbsent(Objects.requireNonNull(resource), k -> new Access()).addRoles(Objects.requireNonNull(roles));
            return this;
        }

        @Nonnull
        public Builder withResourceRole(@Nonnull String resource, @Nonnull String role) {
            this.resourceAccess.computeIfAbsent(Objects.requireNonNull(resource), k -> new Access()).addRole(Objects.requireNonNull(role));
            return this;
        }

        @Nonnull
        public Builder withClaims(@Nonnull Map<String, Object> claims) {
            this.claims.putAll(Objects.requireNonNull(claims));
            return this;
        }

        @Nonnull
        public Builder withClaim(@Nonnull String key, @Nonnull Object value) {
            this.claims.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }

        @Nonnull
        public Builder withIssuedAt(@Nonnull Instant issuedAt) {
            this.issuedAt = Objects.requireNonNull(issuedAt);
            return this;
        }

        @Nonnull
        public Builder withAuthenticationTime(@Nonnull Instant authenticationTime) {
            this.authenticationTime = Objects.requireNonNull(authenticationTime);
            return this;
        }

        @Nonnull
        public Builder withExpiration(@Nonnull Instant expiration) {
            this.expiration = Objects.requireNonNull(expiration);
            return this;
        }

        @Nonnull
        public Builder withNotBefore(@Nullable Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        @Nonnull
        public Builder withGivenName(@Nullable String givenName) {
            this.givenName = givenName;
            return this;
        }

        @Nonnull
        public Builder withFamilyName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @Nonnull
        public Builder withName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder withEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        @Nonnull
        public Builder withPreferredUsername(@Nullable String preferredUsername) {
            this.preferredUsername = preferredUsername;
            return this;
        }

        @Nonnull
        public Builder withAuthenticationContextClassReference(@Nullable String authenticationContextClassReference) {
            this.authenticationContextClassReference = authenticationContextClassReference;
            return this;
        }

        @Nonnull
        public TokenConfig build() {
            return new TokenConfig(this);
        }
    }

    public static class Access {
        @Nonnull
        private final Set<String> roles = new HashSet<String>();

        @Nonnull
        public Set<String> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        void addRole(@Nonnull String role) {
            this.roles.add(Objects.requireNonNull(role));
        }

        void addRoles(@Nonnull Collection<String> newRoles) {
            this.roles.addAll(newRoles);
        }
    }
}

