/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl;

import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.session.UserData;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class TokenGenerator {
    @Nonnull
    private final Key privateKey;
    @Nonnull
    private final String keyId;
    @Nonnull
    private final SignatureAlgorithm algorithm;

    @Inject
    TokenGenerator(@Nonnull Key privateKey, @Nonnull @Named(value="keyId") String keyId, @Nonnull SignatureAlgorithm algorithm) {
        this.privateKey = privateKey;
        this.keyId = keyId;
        this.algorithm = algorithm;
    }

    @Nonnull
    public String getToken(@Nonnull TokenConfig tokenConfig, @Nonnull UrlConfiguration requestConfiguration) {
        JwtBuilder builder = Jwts.builder().setHeaderParam("kid", (Object)this.keyId).claim("aud", tokenConfig.getAudience()).setIssuedAt(new Date(tokenConfig.getIssuedAt().toEpochMilli())).claim("auth_time", (Object)tokenConfig.getAuthenticationTime().getEpochSecond()).setExpiration(new Date(tokenConfig.getExpiration().toEpochMilli())).setIssuer(requestConfiguration.forRequestContext(tokenConfig.getHostname(), tokenConfig.getRealm()).getIssuer().toASCIIString()).setSubject(tokenConfig.getSubject()).claim("scope", (Object)tokenConfig.getScope()).claim("typ", (Object)"Bearer").claim("azp", (Object)tokenConfig.getAuthorizedParty());
        Optional<Object> generatedUserData = tokenConfig.isGenerateUserDataFromSubject() ? Optional.of(UserData.fromUsernameAndHostname(tokenConfig.getSubject(), requestConfiguration.getHostname())) : Optional.empty();
        this.setClaimIfPresent(builder, "nbf", tokenConfig.getNotBefore());
        this.setClaimIfPresent(builder, "name", tokenConfig.getName(), generatedUserData.map(UserData::getName).orElse(null));
        this.setClaimIfPresent(builder, "given_name", tokenConfig.getGivenName(), generatedUserData.map(UserData::getGivenName).orElse(null));
        this.setClaimIfPresent(builder, "family_name", tokenConfig.getFamilyName(), generatedUserData.map(UserData::getFamilyName).orElse(null));
        this.setClaimIfPresent(builder, "email", tokenConfig.getEmail(), generatedUserData.map(UserData::getEmail).orElse(null));
        this.setClaimIfPresent(builder, "preferred_username", tokenConfig.getPreferredUsername(), generatedUserData.map(UserData::getPreferredUsername).orElse(null));
        this.setClaimIfPresent(builder, "acr", tokenConfig.getAuthenticationContextClassReference());
        return builder.claim("realm_access", (Object)tokenConfig.getRealmAccess()).claim("resource_access", tokenConfig.getResourceAccess()).addClaims(tokenConfig.getClaims()).signWith(this.privateKey, this.algorithm).compact();
    }

    public Map<String, Object> parseToken(String token) {
        JwtParser parser = Jwts.parserBuilder().setSigningKey(this.privateKey).build();
        return (Map)parser.parseClaimsJws(token).getBody();
    }

    private void setClaimIfPresent(@Nonnull JwtBuilder builder, @Nonnull String claim, @Nullable String value) {
        if (value != null) {
            Objects.requireNonNull(builder).claim(claim, (Object)value);
        }
    }

    private void setClaimIfPresent(@Nonnull JwtBuilder builder, @Nonnull String claim, @Nullable String value, @Nullable String alternative) {
        if (value != null) {
            Objects.requireNonNull(builder).claim(claim, (Object)value);
        } else if (alternative != null) {
            Objects.requireNonNull(builder).claim(claim, (Object)alternative);
        }
    }

    private void setClaimIfPresent(@Nonnull JwtBuilder builder, @Nonnull String claim, @Nullable Instant value) {
        if (value != null) {
            Objects.requireNonNull(builder).claim(claim, (Object)value.getEpochSecond());
        }
    }
}

