/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.dagger;

import com.tngtech.keycloakmock.api.ServerConfig;
import com.tngtech.keycloakmock.impl.TokenGenerator;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.dagger.ServerComponent;
import com.tngtech.keycloakmock.impl.dagger.ServerModule;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_KeystoreBufferFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideCookie1HandlerFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideCookie2HandlerFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideHttpServerOptionsFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideIframeHandlerFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideKeycloakJsHandlerFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideResourcesFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideRouterFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideScopesFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideServerFactory;
import com.tngtech.keycloakmock.impl.dagger.ServerModule_ProvideTemplateEngineFactory;
import com.tngtech.keycloakmock.impl.handler.AuthenticationRoute;
import com.tngtech.keycloakmock.impl.handler.AuthenticationRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.CommonHandler;
import com.tngtech.keycloakmock.impl.handler.CommonHandler_Factory;
import com.tngtech.keycloakmock.impl.handler.DelegationRoute;
import com.tngtech.keycloakmock.impl.handler.DelegationRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.FailureHandler;
import com.tngtech.keycloakmock.impl.handler.FailureHandler_Factory;
import com.tngtech.keycloakmock.impl.handler.IFrameRoute;
import com.tngtech.keycloakmock.impl.handler.IFrameRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.JwksRoute;
import com.tngtech.keycloakmock.impl.handler.JwksRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.LoginRoute;
import com.tngtech.keycloakmock.impl.handler.LoginRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.LogoutRoute;
import com.tngtech.keycloakmock.impl.handler.LogoutRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.OptionalBasicAuthHandler;
import com.tngtech.keycloakmock.impl.handler.OptionalBasicAuthHandler_Factory;
import com.tngtech.keycloakmock.impl.handler.OutOfBandLoginRoute;
import com.tngtech.keycloakmock.impl.handler.OutOfBandLoginRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.RequestUrlConfigurationHandler;
import com.tngtech.keycloakmock.impl.handler.RequestUrlConfigurationHandler_Factory;
import com.tngtech.keycloakmock.impl.handler.ResourceFileHandler;
import com.tngtech.keycloakmock.impl.handler.TokenRoute;
import com.tngtech.keycloakmock.impl.handler.TokenRoute_Factory;
import com.tngtech.keycloakmock.impl.handler.WellKnownRoute;
import com.tngtech.keycloakmock.impl.handler.WellKnownRoute_Factory;
import com.tngtech.keycloakmock.impl.helper.RedirectHelper;
import com.tngtech.keycloakmock.impl.helper.RedirectHelper_Factory;
import com.tngtech.keycloakmock.impl.helper.TokenHelper;
import com.tngtech.keycloakmock.impl.helper.TokenHelper_Factory;
import com.tngtech.keycloakmock.impl.session.SessionRepository;
import com.tngtech.keycloakmock.impl.session.SessionRepository_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.jsonwebtoken.SignatureAlgorithm;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.common.template.TemplateEngine;
import java.security.KeyStore;
import java.security.PublicKey;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerServerComponent {
    private DaggerServerComponent() {
    }

    public static ServerComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    extends ServerComponent.Builder {
        private Vertx vertx;
        private ServerConfig serverConfig;
        private PublicKey publicKey;
        private String keyId;
        private SignatureAlgorithm signatureAlgorithm;
        private KeyStore keyStore;
        private TokenGenerator tokenGenerator;
        private UrlConfiguration defaultConfiguration;

        private Builder() {
        }

        @Override
        Builder vertx(Vertx vertx) {
            this.vertx = (Vertx)Preconditions.checkNotNull((Object)vertx);
            return this;
        }

        @Override
        public Builder serverConfig(ServerConfig serverConfig) {
            this.serverConfig = (ServerConfig)Preconditions.checkNotNull((Object)serverConfig);
            return this;
        }

        @Override
        public Builder publicKey(PublicKey key) {
            this.publicKey = (PublicKey)Preconditions.checkNotNull((Object)key);
            return this;
        }

        @Override
        public Builder keyId(String keyId) {
            this.keyId = (String)Preconditions.checkNotNull((Object)keyId);
            return this;
        }

        @Override
        public Builder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = (SignatureAlgorithm)Preconditions.checkNotNull((Object)signatureAlgorithm);
            return this;
        }

        @Override
        public Builder keyStore(KeyStore keyStore) {
            this.keyStore = (KeyStore)Preconditions.checkNotNull((Object)keyStore);
            return this;
        }

        @Override
        public Builder tokenGenerator(TokenGenerator tokenGenerator) {
            this.tokenGenerator = (TokenGenerator)Preconditions.checkNotNull((Object)tokenGenerator);
            return this;
        }

        @Override
        public Builder defaultConfiguration(UrlConfiguration defaultConfiguration) {
            this.defaultConfiguration = (UrlConfiguration)Preconditions.checkNotNull((Object)defaultConfiguration);
            return this;
        }

        @Override
        public ServerComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.vertx, Vertx.class);
            Preconditions.checkBuilderRequirement((Object)this.serverConfig, ServerConfig.class);
            Preconditions.checkBuilderRequirement((Object)this.publicKey, PublicKey.class);
            Preconditions.checkBuilderRequirement((Object)this.keyId, String.class);
            Preconditions.checkBuilderRequirement((Object)this.signatureAlgorithm, SignatureAlgorithm.class);
            Preconditions.checkBuilderRequirement((Object)this.keyStore, KeyStore.class);
            Preconditions.checkBuilderRequirement((Object)this.tokenGenerator, TokenGenerator.class);
            Preconditions.checkBuilderRequirement((Object)this.defaultConfiguration, UrlConfiguration.class);
            return new ServerComponentImpl(new ServerModule(), this.vertx, this.serverConfig, this.publicKey, this.keyId, this.signatureAlgorithm, this.keyStore, this.tokenGenerator, this.defaultConfiguration);
        }
    }

    private static final class ServerComponentImpl
    implements ServerComponent {
        private final Vertx vertx;
        private final ServerComponentImpl serverComponentImpl = this;
        private Provider<Vertx> vertxProvider;
        private Provider<UrlConfiguration> defaultConfigurationProvider;
        private Provider<KeyStore> keyStoreProvider;
        private Provider<Buffer> keystoreBufferProvider;
        private Provider<HttpServerOptions> provideHttpServerOptionsProvider;
        private Provider<RequestUrlConfigurationHandler> requestUrlConfigurationHandlerProvider;
        private Provider<CommonHandler> commonHandlerProvider;
        private Provider<FailureHandler> failureHandlerProvider;
        private Provider<String> keyIdProvider;
        private Provider<SignatureAlgorithm> signatureAlgorithmProvider;
        private Provider<PublicKey> publicKeyProvider;
        private Provider<JwksRoute> jwksRouteProvider;
        private Provider<WellKnownRoute> wellKnownRouteProvider;
        private Provider<SessionRepository> sessionRepositoryProvider;
        private Provider<TokenGenerator> tokenGeneratorProvider;
        private Provider<ServerConfig> serverConfigProvider;
        private Provider<List<String>> provideResourcesProvider;
        private Provider<Set<String>> provideScopesProvider;
        private Provider<TokenHelper> tokenHelperProvider;
        private Provider<RedirectHelper> redirectHelperProvider;
        private Provider<TemplateEngine> provideTemplateEngineProvider;
        private Provider<LoginRoute> loginRouteProvider;
        private Provider<AuthenticationRoute> authenticationRouteProvider;
        private Provider<OptionalBasicAuthHandler> optionalBasicAuthHandlerProvider;
        private Provider<TokenRoute> tokenRouteProvider;
        private Provider<ResourceFileHandler> provideIframeHandlerProvider;
        private Provider<IFrameRoute> iFrameRouteProvider;
        private Provider<ResourceFileHandler> provideCookie1HandlerProvider;
        private Provider<ResourceFileHandler> provideCookie2HandlerProvider;
        private Provider<LogoutRoute> logoutRouteProvider;
        private Provider<DelegationRoute> delegationRouteProvider;
        private Provider<OutOfBandLoginRoute> outOfBandLoginRouteProvider;
        private Provider<ResourceFileHandler> provideKeycloakJsHandlerProvider;
        private Provider<Router> provideRouterProvider;
        private Provider<HttpServer> provideServerProvider;

        private ServerComponentImpl(ServerModule serverModuleParam, Vertx vertxParam, ServerConfig serverConfigParam, PublicKey publicKeyParam, String keyIdParam, SignatureAlgorithm signatureAlgorithmParam, KeyStore keyStoreParam, TokenGenerator tokenGeneratorParam, UrlConfiguration defaultConfigurationParam) {
            this.vertx = vertxParam;
            this.initialize(serverModuleParam, vertxParam, serverConfigParam, publicKeyParam, keyIdParam, signatureAlgorithmParam, keyStoreParam, tokenGeneratorParam, defaultConfigurationParam);
        }

        private void initialize(ServerModule serverModuleParam, Vertx vertxParam, ServerConfig serverConfigParam, PublicKey publicKeyParam, String keyIdParam, SignatureAlgorithm signatureAlgorithmParam, KeyStore keyStoreParam, TokenGenerator tokenGeneratorParam, UrlConfiguration defaultConfigurationParam) {
            this.vertxProvider = InstanceFactory.create((Object)vertxParam);
            this.defaultConfigurationProvider = InstanceFactory.create((Object)defaultConfigurationParam);
            this.keyStoreProvider = InstanceFactory.create((Object)keyStoreParam);
            this.keystoreBufferProvider = DoubleCheck.provider((Provider)ServerModule_KeystoreBufferFactory.create(serverModuleParam, this.keyStoreProvider));
            this.provideHttpServerOptionsProvider = DoubleCheck.provider((Provider)ServerModule_ProvideHttpServerOptionsFactory.create(serverModuleParam, this.defaultConfigurationProvider, this.keystoreBufferProvider));
            this.requestUrlConfigurationHandlerProvider = DoubleCheck.provider((Provider)RequestUrlConfigurationHandler_Factory.create(this.defaultConfigurationProvider));
            this.commonHandlerProvider = DoubleCheck.provider((Provider)CommonHandler_Factory.create());
            this.failureHandlerProvider = DoubleCheck.provider((Provider)FailureHandler_Factory.create());
            this.keyIdProvider = InstanceFactory.create((Object)keyIdParam);
            this.signatureAlgorithmProvider = InstanceFactory.create((Object)signatureAlgorithmParam);
            this.publicKeyProvider = InstanceFactory.create((Object)publicKeyParam);
            this.jwksRouteProvider = DoubleCheck.provider((Provider)JwksRoute_Factory.create(this.keyIdProvider, this.signatureAlgorithmProvider, this.publicKeyProvider));
            this.wellKnownRouteProvider = DoubleCheck.provider((Provider)WellKnownRoute_Factory.create());
            this.sessionRepositoryProvider = DoubleCheck.provider((Provider)SessionRepository_Factory.create());
            this.tokenGeneratorProvider = InstanceFactory.create((Object)tokenGeneratorParam);
            this.serverConfigProvider = InstanceFactory.create((Object)serverConfigParam);
            this.provideResourcesProvider = DoubleCheck.provider((Provider)ServerModule_ProvideResourcesFactory.create(serverModuleParam, this.serverConfigProvider));
            this.provideScopesProvider = DoubleCheck.provider((Provider)ServerModule_ProvideScopesFactory.create(serverModuleParam, this.serverConfigProvider));
            this.tokenHelperProvider = DoubleCheck.provider((Provider)TokenHelper_Factory.create(this.tokenGeneratorProvider, this.provideResourcesProvider, this.provideScopesProvider));
            this.redirectHelperProvider = DoubleCheck.provider((Provider)RedirectHelper_Factory.create(this.tokenHelperProvider));
            this.provideTemplateEngineProvider = DoubleCheck.provider((Provider)ServerModule_ProvideTemplateEngineFactory.create(serverModuleParam, this.vertxProvider));
            this.loginRouteProvider = DoubleCheck.provider((Provider)LoginRoute_Factory.create(this.sessionRepositoryProvider, this.redirectHelperProvider, this.provideTemplateEngineProvider));
            this.authenticationRouteProvider = DoubleCheck.provider((Provider)AuthenticationRoute_Factory.create(this.sessionRepositoryProvider, this.redirectHelperProvider));
            this.optionalBasicAuthHandlerProvider = DoubleCheck.provider((Provider)OptionalBasicAuthHandler_Factory.create());
            this.tokenRouteProvider = DoubleCheck.provider((Provider)TokenRoute_Factory.create(this.sessionRepositoryProvider, this.tokenHelperProvider));
            this.provideIframeHandlerProvider = DoubleCheck.provider((Provider)ServerModule_ProvideIframeHandlerFactory.create(serverModuleParam));
            this.iFrameRouteProvider = DoubleCheck.provider((Provider)IFrameRoute_Factory.create(this.provideIframeHandlerProvider));
            this.provideCookie1HandlerProvider = DoubleCheck.provider((Provider)ServerModule_ProvideCookie1HandlerFactory.create(serverModuleParam));
            this.provideCookie2HandlerProvider = DoubleCheck.provider((Provider)ServerModule_ProvideCookie2HandlerFactory.create(serverModuleParam));
            this.logoutRouteProvider = DoubleCheck.provider((Provider)LogoutRoute_Factory.create(this.sessionRepositoryProvider, this.redirectHelperProvider));
            this.delegationRouteProvider = DoubleCheck.provider((Provider)DelegationRoute_Factory.create(this.provideTemplateEngineProvider));
            this.outOfBandLoginRouteProvider = DoubleCheck.provider((Provider)OutOfBandLoginRoute_Factory.create(this.provideTemplateEngineProvider));
            this.provideKeycloakJsHandlerProvider = DoubleCheck.provider((Provider)ServerModule_ProvideKeycloakJsHandlerFactory.create(serverModuleParam));
            this.provideRouterProvider = DoubleCheck.provider((Provider)ServerModule_ProvideRouterFactory.create(serverModuleParam, this.defaultConfigurationProvider, this.vertxProvider, this.requestUrlConfigurationHandlerProvider, this.commonHandlerProvider, this.failureHandlerProvider, this.jwksRouteProvider, this.wellKnownRouteProvider, this.loginRouteProvider, this.authenticationRouteProvider, this.optionalBasicAuthHandlerProvider, this.tokenRouteProvider, this.iFrameRouteProvider, this.provideCookie1HandlerProvider, this.provideCookie2HandlerProvider, this.logoutRouteProvider, this.delegationRouteProvider, this.outOfBandLoginRouteProvider, this.provideKeycloakJsHandlerProvider));
            this.provideServerProvider = DoubleCheck.provider((Provider)ServerModule_ProvideServerFactory.create(serverModuleParam, this.vertxProvider, this.provideHttpServerOptionsProvider, this.provideRouterProvider));
        }

        @Override
        public HttpServer server() {
            return (HttpServer)this.provideServerProvider.get();
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }
    }
}

