/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.dagger;

import com.tngtech.keycloakmock.impl.TokenGenerator;
import com.tngtech.keycloakmock.impl.TokenGenerator_Factory;
import com.tngtech.keycloakmock.impl.dagger.KeyModule;
import com.tngtech.keycloakmock.impl.dagger.KeyModule_ProvideKeyIdFactory;
import com.tngtech.keycloakmock.impl.dagger.KeyModule_ProvideKeystoreFactory;
import com.tngtech.keycloakmock.impl.dagger.KeyModule_ProvidePublicKeyFactory;
import com.tngtech.keycloakmock.impl.dagger.KeyModule_ProvideSecretKeyFactory;
import com.tngtech.keycloakmock.impl.dagger.KeyModule_ProvideSignatureAlgorithmFactory;
import com.tngtech.keycloakmock.impl.dagger.SignatureComponent;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerSignatureComponent {
    private DaggerSignatureComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SignatureComponent create() {
        return new Builder().build();
    }

    public static final class Builder {
        private KeyModule keyModule;

        private Builder() {
        }

        public Builder keyModule(KeyModule keyModule) {
            this.keyModule = (KeyModule)Preconditions.checkNotNull((Object)keyModule);
            return this;
        }

        public SignatureComponent build() {
            if (this.keyModule == null) {
                this.keyModule = new KeyModule();
            }
            return new SignatureComponentImpl(this.keyModule);
        }
    }

    private static final class SignatureComponentImpl
    implements SignatureComponent {
        private final SignatureComponentImpl signatureComponentImpl = this;
        private Provider<KeyStore> provideKeystoreProvider;
        private Provider<PublicKey> providePublicKeyProvider;
        private Provider<String> provideKeyIdProvider;
        private Provider<SignatureAlgorithm> provideSignatureAlgorithmProvider;
        private Provider<Key> provideSecretKeyProvider;
        private Provider<TokenGenerator> tokenGeneratorProvider;

        private SignatureComponentImpl(KeyModule keyModuleParam) {
            this.initialize(keyModuleParam);
        }

        private void initialize(KeyModule keyModuleParam) {
            this.provideKeystoreProvider = DoubleCheck.provider((Provider)KeyModule_ProvideKeystoreFactory.create(keyModuleParam));
            this.providePublicKeyProvider = DoubleCheck.provider((Provider)KeyModule_ProvidePublicKeyFactory.create(keyModuleParam, this.provideKeystoreProvider));
            this.provideKeyIdProvider = DoubleCheck.provider((Provider)KeyModule_ProvideKeyIdFactory.create(keyModuleParam));
            this.provideSignatureAlgorithmProvider = DoubleCheck.provider((Provider)KeyModule_ProvideSignatureAlgorithmFactory.create(keyModuleParam));
            this.provideSecretKeyProvider = DoubleCheck.provider((Provider)KeyModule_ProvideSecretKeyFactory.create(keyModuleParam, this.provideKeystoreProvider));
            this.tokenGeneratorProvider = DoubleCheck.provider((Provider)TokenGenerator_Factory.create(this.provideSecretKeyProvider, this.provideKeyIdProvider, this.provideSignatureAlgorithmProvider));
        }

        @Override
        public KeyStore keyStore() {
            return (KeyStore)this.provideKeystoreProvider.get();
        }

        @Override
        public PublicKey publicKey() {
            return (PublicKey)this.providePublicKeyProvider.get();
        }

        @Override
        public String keyId() {
            return (String)this.provideKeyIdProvider.get();
        }

        @Override
        public SignatureAlgorithm signatureAlgorithm() {
            return (SignatureAlgorithm)this.provideSignatureAlgorithmProvider.get();
        }

        @Override
        public TokenGenerator tokenGenerator() {
            return (TokenGenerator)this.tokenGeneratorProvider.get();
        }
    }
}

