/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DelegationRoute
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationRoute.class);
    private static final String HEADER = "header";
    private static final String BODY = "body";
    @Nonnull
    private final TemplateEngine engine;

    @Inject
    DelegationRoute(@Nonnull TemplateEngine engine) {
        this.engine = engine;
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        if ("true".equals(routingContext.queryParams().get("error"))) {
            routingContext.put(HEADER, (Object)"Delegation failed");
            routingContext.put(BODY, (Object)"You need to check the output of your client to see what went wrong.");
        } else {
            routingContext.put(HEADER, (Object)"Delegation successful");
            routingContext.put(BODY, (Object)"You may now close this browser window.");
        }
        this.engine.render(routingContext.data(), "delegation.ftl").onSuccess(b -> routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html").end(b)).onFailure(t -> {
            LOG.error("Unable to render login page", t);
            routingContext.fail(t);
        });
    }
}

