/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import io.jsonwebtoken.SignatureAlgorithm;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class JwksRoute
implements Handler<RoutingContext> {
    private final String jwksResponse;

    @Inject
    JwksRoute(@Nonnull @Named(value="keyId") String keyId, @Nonnull SignatureAlgorithm algorithm, @Nonnull PublicKey publicKey) {
        this.jwksResponse = new JsonObject().put("keys", (Object)new JsonArray(Collections.singletonList(JwksRoute.toSigningKey(keyId, algorithm.getValue(), publicKey)))).encode();
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        routingContext.response().putHeader("content-type", "application/json").end(this.jwksResponse);
    }

    private static JsonObject toSigningKey(@Nonnull String keyId, @Nonnull String algorithm, @Nonnull PublicKey publicKey) {
        JsonObject result = new JsonObject();
        result.put("kid", (Object)keyId);
        result.put("use", (Object)"sig");
        result.put("alg", (Object)algorithm);
        if (publicKey instanceof RSAPublicKey) {
            result.put("kty", (Object)"RSA");
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            result.put("n", (Object)Base64.getUrlEncoder().encodeToString(rsaKey.getModulus().toByteArray()));
            result.put("e", (Object)Base64.getUrlEncoder().encodeToString(rsaKey.getPublicExponent().toByteArray()));
        } else if (publicKey instanceof ECPublicKey) {
            result.put("kty", (Object)"EC");
            ECPublicKey ecKey = (ECPublicKey)publicKey;
            result.put("crv", (Object)("P-" + ecKey.getParams().getOrder().bitLength()));
            result.put("x", (Object)Base64.getUrlEncoder().encodeToString(ecKey.getW().getAffineX().toByteArray()));
            result.put("y", (Object)Base64.getUrlEncoder().encodeToString(ecKey.getW().getAffineY().toByteArray()));
        } else {
            throw new IllegalStateException("Invalid public key type found");
        }
        return result;
    }
}

