/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.helper.RedirectHelper;
import com.tngtech.keycloakmock.impl.session.SessionRepository;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LogoutRoute
implements Handler<RoutingContext> {
    private static final String LEGACY_REDIRECT_URI = "redirect_uri";
    private static final String POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    @Nonnull
    private final SessionRepository sessionRepository;
    @Nonnull
    private final RedirectHelper redirectHelper;

    @Inject
    LogoutRoute(@Nonnull SessionRepository sessionRepository, @Nonnull RedirectHelper redirectHelper) {
        this.sessionRepository = sessionRepository;
        this.redirectHelper = redirectHelper;
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        String redirectUri = routingContext.queryParams().get(POST_LOGOUT_REDIRECT_URI);
        if (redirectUri == null) {
            redirectUri = routingContext.queryParams().get(LEGACY_REDIRECT_URI);
        }
        UrlConfiguration requestConfiguration = (UrlConfiguration)routingContext.get("requestConfiguration");
        this.invalidateSession(routingContext);
        routingContext.response().addCookie(this.redirectHelper.invalidateSessionCookie(requestConfiguration)).putHeader("location", redirectUri).setStatusCode(302).end();
    }

    private void invalidateSession(RoutingContext routingContext) {
        Optional.ofNullable(routingContext.request().getCookie("KEYCLOAK_SESSION")).map(Cookie::getValue).map(s -> s.split("/")).filter(s -> ((String[])s).length > 0).map(s -> s[((String[])s).length - 1]).ifPresent(this.sessionRepository::removeSession);
    }
}

