/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.helper.TokenHelper;
import com.tngtech.keycloakmock.impl.session.AdHocSession;
import com.tngtech.keycloakmock.impl.session.Session;
import com.tngtech.keycloakmock.impl.session.SessionRepository;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenRoute
implements Handler<RoutingContext> {
    private static final String GRANT_TYPE = "grant_type";
    private static final String CODE = "code";
    private static final String SESSION_STATE = "session_state";
    @Nonnull
    private final SessionRepository sessionRepository;
    @Nonnull
    private final TokenHelper tokenHelper;

    @Inject
    TokenRoute(@Nonnull SessionRepository sessionRepository, @Nonnull TokenHelper tokenHelper) {
        this.sessionRepository = sessionRepository;
        this.tokenHelper = tokenHelper;
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        String grantType = routingContext.request().getFormAttribute(GRANT_TYPE);
        switch (Objects.toString(grantType)) {
            case "authorization_code": {
                this.handleAuthorizationCodeFlow(routingContext);
                break;
            }
            case "refresh_token": {
                this.handleRefreshTokenFlow(routingContext);
                break;
            }
            case "password": {
                this.handlePasswordFlow(routingContext);
                break;
            }
            case "client_credentials": {
                this.handleClientCredentialsFlow(routingContext);
                break;
            }
            default: {
                routingContext.fail(400);
            }
        }
    }

    private void handleAuthorizationCodeFlow(RoutingContext routingContext) {
        String sessionId = routingContext.request().getFormAttribute(CODE);
        UrlConfiguration requestConfiguration = (UrlConfiguration)routingContext.get("requestConfiguration");
        String token = Optional.ofNullable(this.sessionRepository.getSession(sessionId)).map(s -> this.tokenHelper.getToken((Session)s, requestConfiguration)).orElse(null);
        if (token == null) {
            routingContext.fail(404);
            return;
        }
        routingContext.response().putHeader("content-type", "application/json").end(this.toTokenResponse(token, sessionId));
    }

    private void handleRefreshTokenFlow(RoutingContext routingContext) {
        String refreshToken = routingContext.request().getFormAttribute("refresh_token");
        if (refreshToken == null || refreshToken.isEmpty()) {
            routingContext.fail(400);
            return;
        }
        Map<String, Object> token = this.tokenHelper.parseToken(refreshToken);
        String sessionId = (String)token.get(SESSION_STATE);
        routingContext.response().putHeader("content-type", "application/json").end(this.toTokenResponse(refreshToken, sessionId));
    }

    private void handlePasswordFlow(RoutingContext routingContext) {
        User user;
        String clientId = routingContext.request().getFormAttribute("client_id");
        if ((clientId == null || clientId.isEmpty()) && (user = routingContext.user()) != null) {
            clientId = (String)user.get("username");
        }
        if (clientId == null || clientId.isEmpty()) {
            routingContext.fail(400);
            return;
        }
        String username = routingContext.request().getFormAttribute("username");
        if (username == null || username.isEmpty()) {
            routingContext.fail(400);
            return;
        }
        UrlConfiguration requestConfiguration = (UrlConfiguration)routingContext.get("requestConfiguration");
        String password = routingContext.request().getFormAttribute("password");
        AdHocSession session = AdHocSession.fromClientIdUsernameAndPassword(clientId, requestConfiguration.getHostname(), username, password);
        String token = this.tokenHelper.getToken(session, requestConfiguration);
        routingContext.response().putHeader("content-type", "application/json").end(this.toTokenResponse(token, session.getSessionId()));
    }

    private void handleClientCredentialsFlow(RoutingContext routingContext) {
        String clientId = routingContext.request().getFormAttribute("client_id");
        String password = routingContext.request().getFormAttribute("client_secret");
        boolean formBasedAuth = clientId != null && !clientId.isEmpty() && password != null && !password.isEmpty();
        User user = routingContext.user();
        if (user == null && !formBasedAuth) {
            routingContext.fail(401);
            return;
        }
        if (!formBasedAuth) {
            clientId = (String)routingContext.user().get("username");
            password = (String)routingContext.user().get("password");
        }
        if (clientId == null || clientId.isEmpty()) {
            routingContext.fail(400);
            return;
        }
        UrlConfiguration requestConfiguration = (UrlConfiguration)routingContext.get("requestConfiguration");
        AdHocSession session = AdHocSession.fromClientIdUsernameAndPassword(clientId, requestConfiguration.getHostname(), clientId, password);
        String token = this.tokenHelper.getToken(session, requestConfiguration);
        routingContext.response().putHeader("content-type", "application/json").end(this.toTokenResponse(token, session.getSessionId()));
    }

    private String toTokenResponse(String token, String sessionId) {
        return new JsonObject().put("access_token", (Object)token).put("token_type", (Object)"Bearer").put("expires_in", (Object)36000).put("refresh_token", (Object)token).put("refresh_expires_in", (Object)36000).put("id_token", (Object)token).put(SESSION_STATE, (Object)sessionId).encode();
    }
}

