/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.helper;

import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.TokenGenerator;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.session.Session;
import com.tngtech.keycloakmock.impl.session.UserData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class TokenHelper {
    private static final String SESSION_STATE = "session_state";
    private static final String NONCE = "nonce";
    @Nonnull
    private final TokenGenerator tokenGenerator;
    @Nonnull
    private final List<String> resourcesToMapRolesTo;
    @Nonnull
    private final Set<String> defaultScopes;

    @Inject
    TokenHelper(@Nonnull TokenGenerator tokenGenerator, @Nonnull @Named(value="resources") List<String> resourcesToMapRolesTo, @Nonnull @Named(value="scopes") Set<String> defaultScopes) {
        this.tokenGenerator = tokenGenerator;
        this.resourcesToMapRolesTo = resourcesToMapRolesTo;
        this.defaultScopes = defaultScopes;
    }

    @Nullable
    public String getToken(@Nonnull Session session, @Nonnull UrlConfiguration requestConfiguration) {
        UserData userData = session.getUserData();
        TokenConfig.Builder builder = TokenConfig.aTokenConfig().withAuthorizedParty(session.getClientId()).withAudience(session.getClientId()).withSubject(userData.getSubject()).withPreferredUsername(userData.getPreferredUsername()).withGivenName(userData.getGivenName()).withFamilyName(userData.getFamilyName()).withName(userData.getName()).withEmail(userData.getEmail()).withClaim(SESSION_STATE, session.getSessionId()).withAuthenticationContextClassReference("1");
        if (session.getNonce() != null) {
            builder.withClaim(NONCE, session.getNonce());
        }
        if (this.resourcesToMapRolesTo.isEmpty()) {
            builder.withRealmRoles(session.getRoles());
        } else {
            for (String resource : this.resourcesToMapRolesTo) {
                builder.withResourceRoles(resource, session.getRoles());
            }
        }
        this.addDefaultScopesIfConfigured(builder);
        return this.tokenGenerator.getToken(builder.build(), requestConfiguration);
    }

    private void addDefaultScopesIfConfigured(TokenConfig.Builder builder) {
        if (!this.defaultScopes.isEmpty()) {
            builder.withScopes(this.defaultScopes);
        }
    }

    @Nonnull
    public Map<String, Object> parseToken(@Nonnull String token) {
        return this.tokenGenerator.parseToken(token);
    }
}

