/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.api;

import com.tngtech.keycloakmock.impl.Protocol;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ServerConfig {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_CONTEXT_PATH = "/auth";
    private static final int DEFAULT_PORT = 8000;
    private static final String DEFAULT_REALM = "master";
    private static final String DEFAULT_SCOPE = "openid";
    private static final Duration DEFAULT_TOKEN_LIFESPAN = Duration.ofHours(10L);
    private final int port;
    @Nonnull
    private final Protocol protocol;
    @Nonnull
    private final String defaultHostname;
    @Nonnull
    private final String contextPath;
    @Nonnull
    private final String defaultRealm;
    @Nonnull
    private final List<String> resourcesToMapRolesTo;
    @Nonnull
    private final List<String> defaultScopes;
    @Nonnull
    private final Duration defaultTokenLifespan;

    private ServerConfig(@Nonnull Builder builder) {
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.defaultHostname = builder.defaultHostname;
        this.contextPath = builder.contextPath;
        this.defaultRealm = builder.defaultRealm;
        this.resourcesToMapRolesTo = builder.resourcesToMapRolesTo;
        this.defaultScopes = builder.defaultScopes;
        this.defaultTokenLifespan = builder.defaultTokenLifespan;
    }

    @Nonnull
    public static Builder aServerConfig() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public List<String> getResourcesToMapRolesTo() {
        return Collections.unmodifiableList(this.resourcesToMapRolesTo);
    }

    @Nonnull
    @Deprecated
    public String getHostname() {
        return this.getDefaultHostname();
    }

    @Nonnull
    public String getDefaultHostname() {
        return this.defaultHostname;
    }

    @Nonnull
    public String getContextPath() {
        return this.contextPath;
    }

    @Nonnull
    @Deprecated
    public String getRealm() {
        return this.getDefaultRealm();
    }

    @Nonnull
    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    @Nonnull
    public List<String> getDefaultScopes() {
        return Collections.unmodifiableList(this.defaultScopes);
    }

    @Nonnull
    public Duration getDefaultTokenLifespan() {
        return this.defaultTokenLifespan;
    }

    static /* synthetic */ Duration access$900() {
        return DEFAULT_TOKEN_LIFESPAN;
    }

    public static final class Builder {
        private int port = 8000;
        @Nonnull
        private Protocol protocol = Protocol.HTTP;
        @Nonnull
        private String defaultHostname = "localhost";
        @Nonnull
        private String contextPath = "/auth";
        @Nonnull
        private String defaultRealm = "master";
        @Nonnull
        private final List<String> resourcesToMapRolesTo = new ArrayList<String>();
        @Nonnull
        private final List<String> defaultScopes = new ArrayList<String>();
        @Nonnull
        private Duration defaultTokenLifespan = ServerConfig.access$900();

        private Builder() {
            this.defaultScopes.add(ServerConfig.DEFAULT_SCOPE);
        }

        @Nonnull
        public Builder withTls(boolean tls) {
            this.protocol = tls ? Protocol.HTTPS : Protocol.HTTP;
            return this;
        }

        @Nonnull
        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withHostname(@Nonnull String defaultHostname) {
            return this.withDefaultHostname(defaultHostname);
        }

        @Nonnull
        public Builder withDefaultHostname(@Nonnull String defaultHostname) {
            this.defaultHostname = defaultHostname;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withRealm(@Nonnull String defaultRealm) {
            return this.withDefaultRealm(defaultRealm);
        }

        @Nonnull
        public Builder withDefaultRealm(@Nonnull String defaultRealm) {
            this.defaultRealm = defaultRealm;
            return this;
        }

        @Nonnull
        public Builder withResourcesToMapRolesTo(@Nonnull List<String> resources) {
            this.resourcesToMapRolesTo.addAll(resources);
            return this;
        }

        @Nonnull
        public Builder withContextPath(@Nonnull String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        @Nonnull
        public Builder withNoContextPath() {
            this.contextPath = "";
            return this;
        }

        @Nonnull
        public Builder withResourceToMapRolesTo(@Nonnull String resource) {
            this.resourcesToMapRolesTo.add(Objects.requireNonNull(resource));
            return this;
        }

        @Nonnull
        public Builder withDefaultScopes(@Nonnull Collection<String> defaultScopes) {
            this.defaultScopes.addAll(defaultScopes);
            return this;
        }

        @Nonnull
        public Builder withDefaultScope(@Nonnull String defaultScope) {
            this.defaultScopes.add(defaultScope);
            return this;
        }

        @Nonnull
        public Builder withDefaultTokenLifespan(@Nonnull Duration tokenLifespan) {
            this.defaultTokenLifespan = tokenLifespan;
            return this;
        }

        @Nonnull
        public ServerConfig build() {
            return new ServerConfig(this);
        }
    }
}

