/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl;

import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.session.UserData;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class TokenGenerator {
    @Nonnull
    private final PublicKey publicKey;
    @Nonnull
    private final Key privateKey;
    @Nonnull
    private final String keyId;
    @Nonnull
    private final List<String> defaultScopes;
    @Nonnull
    private final Duration defaultTokenLifespan;

    @Inject
    TokenGenerator(@Nonnull PublicKey publicKey, @Nonnull Key privateKey, @Nonnull @Named(value="keyId") String keyId, @Nonnull @Named(value="scopes") List<String> defaultScopes, @Nonnull Duration defaultTokenLifespan) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.keyId = keyId;
        this.defaultScopes = defaultScopes;
        this.defaultTokenLifespan = defaultTokenLifespan;
    }

    @Nonnull
    public String getToken(@Nonnull TokenConfig tokenConfig, @Nonnull UrlConfiguration requestConfiguration) {
        JwtBuilder builder = ((JwtBuilder)((NestedCollection)((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().header().keyId(this.keyId)).type("JWT")).and()).audience().add(tokenConfig.getAudience())).and()).issuedAt(new Date(tokenConfig.getIssuedAt().toEpochMilli())).claim("auth_time", (Object)tokenConfig.getAuthenticationTime().getEpochSecond()).issuer(requestConfiguration.forRequestContext(tokenConfig.getHostname(), tokenConfig.getRealm()).getIssuer().toASCIIString()).subject(tokenConfig.getSubject()).claim("scope", (Object)this.encodeGivenOrDefaultScopes(tokenConfig.getScopes())).claim("typ", (Object)"Bearer").claim("azp", (Object)tokenConfig.getAuthorizedParty()).claim("sid", (Object)tokenConfig.getSessionId()).claim("session_state", (Object)tokenConfig.getSessionId());
        if (tokenConfig.getNotBefore() != null) {
            builder.notBefore(new Date(tokenConfig.getNotBefore().toEpochMilli()));
        }
        if (tokenConfig.getExpiration() != null) {
            builder.expiration(new Date(tokenConfig.getExpiration().toEpochMilli()));
        } else {
            builder.expiration(new Date(tokenConfig.getIssuedAt().plus(this.defaultTokenLifespan).toEpochMilli()));
        }
        if (tokenConfig.isGenerateUserDataFromSubject()) {
            UserData generatedUserData = UserData.fromUsernameAndHostname(tokenConfig.getSubject(), requestConfiguration.getHostname());
            builder.claim("name", (Object)Optional.ofNullable(tokenConfig.getName()).orElse(generatedUserData.getName())).claim("given_name", (Object)Optional.ofNullable(tokenConfig.getGivenName()).orElse(generatedUserData.getGivenName())).claim("family_name", (Object)Optional.ofNullable(tokenConfig.getFamilyName()).orElse(generatedUserData.getFamilyName())).claim("email", (Object)Optional.ofNullable(tokenConfig.getEmail()).orElse(generatedUserData.getEmail())).claim("preferred_username", (Object)Optional.ofNullable(tokenConfig.getPreferredUsername()).orElse(generatedUserData.getPreferredUsername()));
        } else {
            builder.claim("name", (Object)tokenConfig.getName()).claim("given_name", (Object)tokenConfig.getGivenName()).claim("family_name", (Object)tokenConfig.getFamilyName()).claim("email", (Object)tokenConfig.getEmail()).claim("preferred_username", (Object)tokenConfig.getPreferredUsername());
        }
        return ((JwtBuilder)((JwtBuilder.BuilderClaims)builder.claim("acr", (Object)tokenConfig.getAuthenticationContextClassReference()).claim("realm_access", (Object)tokenConfig.getRealmAccess()).claim("resource_access", tokenConfig.getResourceAccess()).claims().add(tokenConfig.getClaims())).and()).signWith(this.privateKey).compact();
    }

    private String encodeGivenOrDefaultScopes(List<String> scopes) {
        if (scopes.isEmpty()) {
            return Stream.concat(Stream.of("openid"), this.defaultScopes.stream()).distinct().collect(Collectors.joining(" "));
        }
        return Stream.concat(Stream.of("openid"), scopes.stream()).distinct().collect(Collectors.joining(" "));
    }

    public Map<String, Object> parseToken(@Nonnull String token) {
        JwtParser parser = Jwts.parser().verifyWith(this.publicKey).build();
        return (Map)parser.parseSignedClaims((CharSequence)token).getPayload();
    }
}

