/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.dagger;

import com.tngtech.keycloakmock.api.ServerConfig;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.handler.AuthenticationRoute;
import com.tngtech.keycloakmock.impl.handler.CommonHandler;
import com.tngtech.keycloakmock.impl.handler.FailureHandler;
import com.tngtech.keycloakmock.impl.handler.IFrameRoute;
import com.tngtech.keycloakmock.impl.handler.JwksRoute;
import com.tngtech.keycloakmock.impl.handler.LoginRoute;
import com.tngtech.keycloakmock.impl.handler.LogoutRoute;
import com.tngtech.keycloakmock.impl.handler.OptionalBasicAuthHandler;
import com.tngtech.keycloakmock.impl.handler.OutOfBandLoginRoute;
import com.tngtech.keycloakmock.impl.handler.ResourceFileHandler;
import com.tngtech.keycloakmock.impl.handler.TokenRoute;
import com.tngtech.keycloakmock.impl.handler.WellKnownRoute;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public class ServerModule {
    private static final Logger LOG = LoggerFactory.getLogger(ServerModule.class);

    @Provides
    @Singleton
    TemplateEngine provideTemplateEngine(@Nonnull Vertx vertx) {
        return FreeMarkerTemplateEngine.create((Vertx)vertx);
    }

    @Provides
    @Singleton
    @Named(value="iframe")
    ResourceFileHandler provideIframeHandler() {
        return new ResourceFileHandler("/org/keycloak/protocol/oidc/endpoints/login-status-iframe.html");
    }

    @Provides
    @Singleton
    @Named(value="cookie1")
    ResourceFileHandler provideCookie1Handler() {
        return new ResourceFileHandler("/org/keycloak/protocol/oidc/endpoints/3p-cookies-step1.html");
    }

    @Provides
    @Singleton
    @Named(value="cookie2")
    ResourceFileHandler provideCookie2Handler() {
        return new ResourceFileHandler("/org/keycloak/protocol/oidc/endpoints/3p-cookies-step2.html");
    }

    @Provides
    @Singleton
    @Named(value="keycloakJs")
    ResourceFileHandler provideKeycloakJsHandler() {
        return new ResourceFileHandler("/package/lib/keycloak.js");
    }

    @Provides
    @Singleton
    @Named(value="resources")
    List<String> provideResources(@Nonnull ServerConfig serverConfig) {
        return serverConfig.getResourcesToMapRolesTo();
    }

    @Provides
    @Singleton
    @Named(value="scopes")
    List<String> provideScopes(@Nonnull ServerConfig serverConfig) {
        return serverConfig.getDefaultScopes();
    }

    @Provides
    @Singleton
    @Named(value="tokenLifespan")
    Duration provideTokenLifespan(@Nonnull ServerConfig serverConfig) {
        return serverConfig.getDefaultTokenLifespan();
    }

    @Provides
    @Singleton
    Buffer keystoreBuffer(@Nonnull KeyStore keyStore) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            keyStore.store(outputStream, new char[0]);
            return Buffer.buffer((byte[])outputStream.toByteArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Unable to prepare keystore for TLS", e);
        }
    }

    @Provides
    @Singleton
    HttpServerOptions provideHttpServerOptions(@Nonnull UrlConfiguration defaultConfiguration, @Nonnull Lazy<Buffer> keyStoreBuffer) {
        HttpServerOptions options = new HttpServerOptions().setPort(defaultConfiguration.getPort());
        if (defaultConfiguration.getProtocol().isTls()) {
            options.setSsl(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setValue((Buffer)keyStoreBuffer.get()).setPassword(""));
        }
        return options;
    }

    @Provides
    @Singleton
    Router provideRouter(@Nonnull UrlConfiguration defaultConfiguration, @Nonnull Vertx vertx, @Nonnull CommonHandler commonHandler, @Nonnull FailureHandler failureHandler, @Nonnull JwksRoute jwksRoute, @Nonnull WellKnownRoute wellKnownRoute, @Nonnull LoginRoute loginRoute, @Nonnull AuthenticationRoute authenticationRoute, @Nonnull OptionalBasicAuthHandler basicAuthHandler, @Nonnull TokenRoute tokenRoute, @Nonnull IFrameRoute iframeRoute, @Nonnull @Named(value="cookie1") ResourceFileHandler thirdPartyCookies1Route, @Nonnull @Named(value="cookie2") ResourceFileHandler thirdPartyCookies2Route, @Nonnull LogoutRoute logoutRoute, @Nonnull OutOfBandLoginRoute outOfBandLoginRoute, @Nonnull @Named(value="keycloakJs") ResourceFileHandler keycloakJsRoute) {
        UrlConfiguration routing = defaultConfiguration.forRequestContext(null, ":realm");
        Router router = Router.router((Vertx)vertx);
        router.route().handler((Handler)commonHandler).failureHandler((Handler)failureHandler).failureHandler((Handler)ErrorHandler.create((Vertx)vertx));
        router.get(routing.getJwksUri().getPath()).handler((Handler)jwksRoute);
        router.get(routing.getIssuerPath().resolve(".well-known/*").getPath()).handler((Handler)wellKnownRoute);
        router.get(routing.getAuthorizationEndpoint().getPath()).handler((Handler)loginRoute);
        router.post(routing.getAuthenticationCallbackEndpoint(":sessionId").getPath()).handler((Handler)BodyHandler.create()).handler((Handler)authenticationRoute);
        router.post(routing.getTokenEndpoint().getPath()).handler((Handler)BodyHandler.create()).handler((Handler)basicAuthHandler).handler((Handler)tokenRoute);
        router.get(routing.getOpenIdPath("login-status-iframe.html*").getPath()).handler((Handler)iframeRoute);
        router.get(routing.getOpenIdPath("3p-cookies/step1.html").getPath()).handler((Handler)thirdPartyCookies1Route);
        router.get(routing.getOpenIdPath("3p-cookies/step2.html").getPath()).handler((Handler)thirdPartyCookies2Route);
        router.route(routing.getEndSessionEndpoint().getPath()).method(HttpMethod.GET).method(HttpMethod.POST).handler((Handler)logoutRoute);
        router.get(routing.getOutOfBandLoginLoginEndpoint().getPath()).handler((Handler)outOfBandLoginRoute);
        router.route("/auth/js/keycloak.js").handler((Handler)keycloakJsRoute);
        return router;
    }

    @Provides
    @Singleton
    HttpServer provideServer(@Nonnull Vertx vertx, @Nonnull HttpServerOptions options, @Nonnull Router router) {
        return vertx.createHttpServer(options).requestHandler((Handler)router).exceptionHandler(t -> LOG.error("Exception while processing request", t));
    }
}

