/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import com.tngtech.keycloakmock.impl.UrlConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WellKnownRoute
implements Handler<RoutingContext> {
    @Nonnull
    private final UrlConfiguration baseConfiguration;

    @Inject
    WellKnownRoute(@Nonnull UrlConfiguration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        UrlConfiguration requestConfiguration = this.baseConfiguration.forRequestContext(routingContext);
        routingContext.response().putHeader("content-type", "application/json").end(this.getConfiguration(requestConfiguration).encode());
    }

    private JsonObject getConfiguration(@Nonnull UrlConfiguration requestConfiguration) {
        JsonObject result = new JsonObject();
        result.put("issuer", (Object)requestConfiguration.getIssuer().toASCIIString()).put("authorization_endpoint", (Object)requestConfiguration.getAuthorizationEndpoint().toASCIIString()).put("token_endpoint", (Object)requestConfiguration.getTokenEndpoint().toASCIIString()).put("jwks_uri", (Object)requestConfiguration.getJwksUri().toASCIIString()).put("end_session_endpoint", (Object)requestConfiguration.getEndSessionEndpoint().toASCIIString()).put("response_types_supported", (Object)new JsonArray(Arrays.asList("code", "code id_token", "id_token", "token id_token"))).put("subject_types_supported", (Object)new JsonArray(Collections.singletonList("public"))).put("id_token_signing_alg_values_supported", (Object)new JsonArray(Collections.singletonList("RS256")));
        return result;
    }
}

