/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.helper;

import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.helper.TokenHelper;
import com.tngtech.keycloakmock.impl.session.PersistentSession;
import com.tngtech.keycloakmock.impl.session.ResponseMode;
import com.tngtech.keycloakmock.impl.session.ResponseType;
import io.vertx.core.http.Cookie;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RedirectHelper {
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    private static final Logger LOG = LoggerFactory.getLogger(RedirectHelper.class);
    private static final String STATE = "state";
    private static final String SESSION_STATE = "session_state";
    private static final String CODE = "code";
    private static final String ID_TOKEN = "id_token";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_TYPE = "token_type";
    private static final String OOB_REDIRECT = "urn:ietf:wg:oauth:2.0:oob";
    private static final String DUMMY_USER_ID = "dummy-user-id";
    @Nonnull
    private final TokenHelper tokenHelper;

    @Inject
    RedirectHelper(@Nonnull TokenHelper tokenHelper) {
        this.tokenHelper = tokenHelper;
    }

    @Nullable
    public String getRedirectLocation(@Nonnull PersistentSession session, @Nonnull UrlConfiguration requestConfiguration) {
        ResponseType responseType = ResponseType.fromValueOrNull(session.getResponseType());
        if (responseType == null) {
            LOG.warn("Invalid response type '{}' requested!", (Object)session.getResponseType());
            return null;
        }
        ResponseMode responseMode = responseType.getValidResponseMode(session.getResponseMode());
        String originalRedirectUri = session.getRedirectUri();
        StringBuilder redirectUri = OOB_REDIRECT.equals(originalRedirectUri) ? new StringBuilder(requestConfiguration.getOutOfBandLoginLoginEndpoint().toASCIIString()) : new StringBuilder(originalRedirectUri);
        redirectUri.append(this.getResponseParameter(responseMode, SESSION_STATE, session.getSessionId()));
        redirectUri.append(this.getResponseParameter(null, STATE, session.getState()));
        String token = this.tokenHelper.getToken(session, requestConfiguration);
        if (token == null) {
            LOG.warn("No token available for session {}", (Object)session.getSessionId());
            return null;
        }
        switch (responseType) {
            case CODE: {
                redirectUri.append(this.getResponseParameter(null, CODE, session.getSessionId()));
                break;
            }
            case ID_TOKEN: {
                redirectUri.append(this.getResponseParameter(null, ID_TOKEN, token));
                break;
            }
            case ID_TOKEN_PLUS_TOKEN: {
                redirectUri.append(this.getResponseParameter(null, ID_TOKEN, token));
                redirectUri.append(this.getResponseParameter(null, ACCESS_TOKEN, token));
                redirectUri.append(this.getResponseParameter(null, TOKEN_TYPE, "bearer"));
                break;
            }
        }
        return redirectUri.toString();
    }

    @Nonnull
    public Cookie getSessionCookie(@Nonnull PersistentSession session, @Nonnull UrlConfiguration requestConfiguration) {
        return Cookie.cookie((String)KEYCLOAK_SESSION_COOKIE, (String)String.join((CharSequence)"/", requestConfiguration.getRealm(), DUMMY_USER_ID, session.getSessionId())).setPath(requestConfiguration.getIssuerPath().getPath()).setMaxAge(36000L).setSecure(false);
    }

    @Nonnull
    public Cookie invalidateSessionCookie(@Nonnull UrlConfiguration requestConfiguration) {
        return Cookie.cookie((String)KEYCLOAK_SESSION_COOKIE, (String)String.join((CharSequence)"/", requestConfiguration.getRealm(), DUMMY_USER_ID)).setPath(requestConfiguration.getIssuerPath().getPath()).setMaxAge(0L).setSecure(false);
    }

    private String getResponseParameter(@Nullable ResponseMode responseMode, @Nonnull String name, @Nullable String value) {
        if (value == null) {
            return "";
        }
        return (responseMode != null ? responseMode.getSign() : "&") + name + "=" + value;
    }
}

