/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.helper;

import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.TokenGenerator;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.session.Session;
import com.tngtech.keycloakmock.impl.session.UserData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class TokenHelper {
    private static final String NONCE = "nonce";
    @Nonnull
    private final TokenGenerator tokenGenerator;
    @Nonnull
    private final List<String> resourcesToMapRolesTo;

    @Inject
    TokenHelper(@Nonnull TokenGenerator tokenGenerator, @Nonnull @Named(value="resources") List<String> resourcesToMapRolesTo) {
        this.tokenGenerator = tokenGenerator;
        this.resourcesToMapRolesTo = resourcesToMapRolesTo;
    }

    @Nullable
    public String getToken(@Nonnull Session session, @Nonnull UrlConfiguration requestConfiguration) {
        UserData userData = session.getUserData();
        TokenConfig.Builder builder = TokenConfig.aTokenConfig().withAuthorizedParty(session.getClientId()).withAudience(session.getClientId()).withSubject(userData.getSubject()).withPreferredUsername(userData.getPreferredUsername()).withGivenName(userData.getGivenName()).withFamilyName(userData.getFamilyName()).withName(userData.getName()).withEmail(userData.getEmail()).withSessionId(session.getSessionId()).withAuthenticationContextClassReference("1");
        if (session.getNonce() != null) {
            builder.withClaim(NONCE, session.getNonce());
        }
        if (this.resourcesToMapRolesTo.isEmpty()) {
            builder.withRealmRoles(session.getRoles());
        } else {
            for (String resource : this.resourcesToMapRolesTo) {
                builder.withResourceRoles(resource, session.getRoles());
            }
        }
        return this.tokenGenerator.getToken(builder.build(), requestConfiguration);
    }

    @Nonnull
    public Map<String, Object> parseToken(@Nonnull String token) {
        return this.tokenGenerator.parseToken(token);
    }
}

