/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.api;

import com.tngtech.keycloakmock.api.MockServerException;
import com.tngtech.keycloakmock.api.ServerConfig;
import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.dagger.DaggerServerComponent;
import com.tngtech.keycloakmock.impl.dagger.DaggerSignatureComponent;
import com.tngtech.keycloakmock.impl.dagger.ServerComponent;
import com.tngtech.keycloakmock.impl.dagger.SignatureComponent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakMock {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakMock.class);
    @Nonnull
    private final ServerConfig serverConfig;
    @Nonnull
    private final UrlConfiguration defaultConfiguration;
    @Nonnull
    private final SignatureComponent signatureComponent;
    @Nullable
    private ServerComponent serverComponent;

    public KeycloakMock() {
        this(ServerConfig.aServerConfig().build());
    }

    public KeycloakMock(@Nonnull ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.defaultConfiguration = new UrlConfiguration(serverConfig);
        this.signatureComponent = DaggerSignatureComponent.builder().defaultScopes(serverConfig.getDefaultScopes()).defaultAudiences(serverConfig.getDefaultAudiences()).defaultTokenLifespan(serverConfig.getDefaultTokenLifespan()).build();
    }

    @Nonnull
    public String getAccessToken(@Nonnull TokenConfig tokenConfig) {
        return this.signatureComponent.tokenGenerator().getToken(tokenConfig, this.defaultConfiguration);
    }

    public synchronized void start() {
        if (this.serverComponent != null) {
            LOG.warn("Start request ignored as server is already running");
            return;
        }
        ResultHandler startHandler = new ResultHandler();
        this.serverComponent = DaggerServerComponent.builder().serverConfig(this.serverConfig).publicKey(this.signatureComponent.publicKey()).keyId(this.signatureComponent.keyId()).keyStore(this.signatureComponent.keyStore()).tokenGenerator(this.signatureComponent.tokenGenerator()).defaultConfiguration(this.defaultConfiguration).build();
        this.serverComponent.server().listen(startHandler);
        startHandler.await();
    }

    public synchronized void stop() {
        if (this.serverComponent != null) {
            ResultHandler stopServerHandler = new ResultHandler();
            this.serverComponent.server().close(stopServerHandler);
            stopServerHandler.await();
            ResultHandler stopVertxHandler = new ResultHandler();
            this.serverComponent.vertx().close(stopVertxHandler);
            stopVertxHandler.await();
            this.serverComponent = null;
        }
    }

    private static class ResultHandler<E>
    implements Handler<AsyncResult<E>> {
        @Nonnull
        private final CompletableFuture<Void> future = new CompletableFuture();

        private ResultHandler() {
        }

        public void handle(@Nonnull AsyncResult<E> result) {
            if (result.succeeded()) {
                this.future.complete(null);
            } else {
                this.future.completeExceptionally(result.cause());
            }
        }

        void await() {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MockServerException("Interrupted while starting/stopping mock server", e);
            }
            catch (ExecutionException e) {
                throw new MockServerException("Error while starting/stopping mock server: " + e.getMessage(), e);
            }
        }
    }
}

