/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.api;

import com.tngtech.keycloakmock.api.LoginRoleMapping;
import com.tngtech.keycloakmock.impl.Protocol;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ServerConfig {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_CONTEXT_PATH = "/auth";
    private static final int DEFAULT_PORT = 8000;
    private static final String DEFAULT_REALM = "master";
    private static final String DEFAULT_SCOPE = "openid";
    private static final Duration DEFAULT_TOKEN_LIFESPAN = Duration.ofHours(10L);
    private final int port;
    @Nonnull
    private final Protocol protocol;
    @Nonnull
    private final String defaultHostname;
    @Nonnull
    private final String contextPath;
    @Nonnull
    private final String defaultRealm;
    @Nonnull
    private final List<String> defaultAudiences;
    @Nonnull
    private final List<String> defaultScopes;
    @Nonnull
    private final Duration defaultTokenLifespan;
    @Nonnull
    private final LoginRoleMapping loginRoleMapping;

    private ServerConfig(@Nonnull Builder builder) {
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.defaultHostname = builder.defaultHostname;
        this.contextPath = builder.contextPath;
        this.defaultRealm = builder.defaultRealm;
        this.defaultAudiences = builder.defaultAudiences.isEmpty() ? Collections.singletonList("server") : builder.defaultAudiences;
        this.defaultScopes = builder.defaultScopes;
        this.defaultTokenLifespan = builder.defaultTokenLifespan;
        this.loginRoleMapping = builder.loginRoleMapping;
    }

    @Nonnull
    public static Builder aServerConfig() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public List<String> getDefaultAudiences() {
        return Collections.unmodifiableList(this.defaultAudiences);
    }

    @Nonnull
    public String getDefaultHostname() {
        return this.defaultHostname;
    }

    @Nonnull
    public String getContextPath() {
        return this.contextPath;
    }

    @Nonnull
    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    @Nonnull
    public List<String> getDefaultScopes() {
        return Collections.unmodifiableList(this.defaultScopes);
    }

    @Nonnull
    public Duration getDefaultTokenLifespan() {
        return this.defaultTokenLifespan;
    }

    @Nonnull
    public LoginRoleMapping getLoginRoleMapping() {
        return this.loginRoleMapping;
    }

    static /* synthetic */ Duration access$1000() {
        return DEFAULT_TOKEN_LIFESPAN;
    }

    public static final class Builder {
        private int port = 8000;
        @Nonnull
        private Protocol protocol = Protocol.HTTP;
        @Nonnull
        private String defaultHostname = "localhost";
        @Nonnull
        private String contextPath = "/auth";
        @Nonnull
        private String defaultRealm = "master";
        @Nonnull
        private final List<String> defaultAudiences = new ArrayList<String>();
        @Nonnull
        private final List<String> defaultScopes = new ArrayList<String>();
        @Nonnull
        private Duration defaultTokenLifespan = ServerConfig.access$1000();
        @Nonnull
        private LoginRoleMapping loginRoleMapping = LoginRoleMapping.TO_REALM;

        private Builder() {
            this.defaultScopes.add(ServerConfig.DEFAULT_SCOPE);
        }

        @Nonnull
        public Builder withTls(boolean tls) {
            this.protocol = tls ? Protocol.HTTPS : Protocol.HTTP;
            return this;
        }

        @Nonnull
        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder withDefaultHostname(@Nonnull String defaultHostname) {
            this.defaultHostname = defaultHostname;
            return this;
        }

        @Nonnull
        public Builder withDefaultRealm(@Nonnull String defaultRealm) {
            this.defaultRealm = defaultRealm;
            return this;
        }

        @Nonnull
        public Builder withDefaultAudiences(@Nonnull Collection<String> audiences) {
            this.defaultAudiences.addAll(audiences);
            return this;
        }

        @Nonnull
        public Builder withDefaultAudience(@Nonnull String resource) {
            this.defaultAudiences.add(Objects.requireNonNull(resource));
            return this;
        }

        @Nonnull
        public Builder withContextPath(@Nonnull String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        @Nonnull
        public Builder withNoContextPath() {
            this.contextPath = "";
            return this;
        }

        @Nonnull
        public Builder withDefaultScopes(@Nonnull Collection<String> defaultScopes) {
            this.defaultScopes.addAll(defaultScopes);
            return this;
        }

        @Nonnull
        public Builder withDefaultScope(@Nonnull String defaultScope) {
            this.defaultScopes.add(defaultScope);
            return this;
        }

        @Nonnull
        public Builder withDefaultTokenLifespan(@Nonnull Duration tokenLifespan) {
            this.defaultTokenLifespan = tokenLifespan;
            return this;
        }

        @Nonnull
        public Builder withLoginRoleMapping(@Nonnull LoginRoleMapping loginRoleMapping) {
            this.loginRoleMapping = loginRoleMapping;
            return this;
        }

        @Nonnull
        public ServerConfig build() {
            return new ServerConfig(this);
        }
    }
}

