/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl;

import com.tngtech.keycloakmock.api.ServerConfig;
import com.tngtech.keycloakmock.impl.Protocol;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrlConfiguration {
    private static final String ISSUER_PATH = "/realms/";
    private static final String AUTHENTICATION_CALLBACK_PATH = "authenticate/";
    private static final String OUT_OF_BAND_PATH = "oob";
    private static final String ISSUER_OPEN_ID_PATH = "protocol/openid-connect/";
    private static final String OPEN_ID_TOKEN_PATH = "token";
    private static final String OPEN_ID_JWKS_PATH = "certs";
    private static final String OPEN_ID_AUTHORIZATION_PATH = "auth";
    private static final String OPEN_ID_END_SESSION_PATH = "logout";
    @Nonnull
    private final Protocol protocol;
    private final int port;
    @Nonnull
    private final String hostname;
    @Nonnull
    private final String contextPath;
    @Nonnull
    private final String realm;

    public UrlConfiguration(@Nonnull ServerConfig serverConfig) {
        this.protocol = Objects.requireNonNull(serverConfig.getProtocol());
        this.port = serverConfig.getPort();
        this.hostname = this.protocol.getDefaultPort() == serverConfig.getPort() || serverConfig.getDefaultHostname().contains(":") ? serverConfig.getDefaultHostname() : serverConfig.getDefaultHostname() + ":" + serverConfig.getPort();
        this.contextPath = Objects.requireNonNull(serverConfig.getContextPath()).isEmpty() || "/".equals(serverConfig.getContextPath()) ? "" : (serverConfig.getContextPath().startsWith("/") ? serverConfig.getContextPath() : "/".concat(serverConfig.getContextPath()));
        this.realm = Objects.requireNonNull(serverConfig.getDefaultRealm());
    }

    private UrlConfiguration(@Nonnull UrlConfiguration baseConfiguration, @Nullable String requestHost, @Nullable String requestRealm) {
        this.protocol = baseConfiguration.protocol;
        this.port = baseConfiguration.port;
        this.hostname = requestHost != null ? requestHost : baseConfiguration.hostname;
        this.contextPath = baseConfiguration.contextPath;
        this.realm = requestRealm != null ? requestRealm : baseConfiguration.realm;
    }

    @Nonnull
    public UrlConfiguration forRequestContext(@Nullable String requestHost, @Nullable String requestRealm) {
        return new UrlConfiguration(this, requestHost, requestRealm);
    }

    @Nonnull
    public UrlConfiguration forRequestContext(RoutingContext routingContext) {
        String requestHostname = routingContext.request().getHeader("Host");
        String requestRealm = routingContext.pathParam("realm");
        return new UrlConfiguration(this, requestHostname, requestRealm);
    }

    @Nonnull
    URI getBaseUrl() {
        try {
            return new URI(this.protocol.getValue() + this.hostname);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid URL encountered", e);
        }
    }

    @Nonnull
    URI getContextPath(String path) {
        return this.getBaseUrl().resolve(this.contextPath + path);
    }

    @Nonnull
    public URI getJs() {
        return this.getContextPath("/js");
    }

    @Nonnull
    public URI getJsPath() {
        return this.getContextPath("/js/");
    }

    @Nonnull
    public URI getIssuer() {
        return this.getContextPath(ISSUER_PATH + this.realm);
    }

    @Nonnull
    public URI getIssuerPath() {
        return this.getContextPath(ISSUER_PATH + this.realm + "/");
    }

    @Nonnull
    public URI getOpenIdPath(@Nonnull String path) {
        return this.getIssuerPath().resolve(ISSUER_OPEN_ID_PATH).resolve(path);
    }

    @Nonnull
    public URI getAuthenticationCallbackEndpoint(@Nonnull String sessionId) {
        return this.getIssuerPath().resolve(AUTHENTICATION_CALLBACK_PATH + sessionId);
    }

    @Nonnull
    public URI getOutOfBandLoginLoginEndpoint() {
        return this.getIssuerPath().resolve(OUT_OF_BAND_PATH);
    }

    @Nonnull
    public URI getAuthorizationEndpoint() {
        return this.getOpenIdPath(OPEN_ID_AUTHORIZATION_PATH);
    }

    @Nonnull
    public URI getEndSessionEndpoint() {
        return this.getOpenIdPath(OPEN_ID_END_SESSION_PATH);
    }

    @Nonnull
    public URI getTokenEndpoint() {
        return this.getOpenIdPath(OPEN_ID_TOKEN_PATH);
    }

    @Nonnull
    public URI getJwksUri() {
        return this.getOpenIdPath(OPEN_ID_JWKS_PATH);
    }

    @Nonnull
    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public String getHostname() {
        return this.hostname;
    }

    @Nonnull
    public String getRealm() {
        return this.realm;
    }
}

