/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.dagger;

import com.tngtech.keycloakmock.api.LoginRoleMapping;
import com.tngtech.keycloakmock.api.ServerConfig;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.handler.AuthenticationRoute;
import com.tngtech.keycloakmock.impl.handler.CommonHandler;
import com.tngtech.keycloakmock.impl.handler.DocumentationRoute;
import com.tngtech.keycloakmock.impl.handler.FailureHandler;
import com.tngtech.keycloakmock.impl.handler.IFrameRoute;
import com.tngtech.keycloakmock.impl.handler.JwksRoute;
import com.tngtech.keycloakmock.impl.handler.LoginRoute;
import com.tngtech.keycloakmock.impl.handler.LogoutRoute;
import com.tngtech.keycloakmock.impl.handler.OptionalBasicAuthHandler;
import com.tngtech.keycloakmock.impl.handler.OutOfBandLoginRoute;
import com.tngtech.keycloakmock.impl.handler.ResourceFileHandler;
import com.tngtech.keycloakmock.impl.handler.TokenRoute;
import com.tngtech.keycloakmock.impl.handler.WellKnownRoute;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public class ServerModule {
    private static final Logger LOG = LoggerFactory.getLogger(ServerModule.class);

    @Provides
    @Singleton
    TemplateEngine provideTemplateEngine(@Nonnull Vertx vertx) {
        return FreeMarkerTemplateEngine.create((Vertx)vertx);
    }

    @Provides
    @Singleton
    @Named(value="webCryptoShimJs")
    ResourceFileHandler provideWebCryptoShimJsHandler() {
        return new ResourceFileHandler("/theme/keycloak/common/resources/vendor/web-crypto-shim/web-crypto-shim.js");
    }

    @Provides
    @Singleton
    @Named(value="cookie1")
    ResourceFileHandler provideCookie1Handler() {
        return new ResourceFileHandler("/org/keycloak/protocol/oidc/endpoints/3p-cookies-step1.html");
    }

    @Provides
    @Singleton
    @Named(value="cookie2")
    ResourceFileHandler provideCookie2Handler() {
        return new ResourceFileHandler("/org/keycloak/protocol/oidc/endpoints/3p-cookies-step2.html");
    }

    @Provides
    @Singleton
    @Named(value="keycloakJs")
    ResourceFileHandler provideKeycloakJsHandler() {
        return new ResourceFileHandler("/package/dist/keycloak.js");
    }

    @Provides
    @Singleton
    @Named(value="stylesheet")
    ResourceFileHandler provideStylesheetHandler() {
        return new ResourceFileHandler("/style.css");
    }

    @Provides
    @Singleton
    Buffer keystoreBuffer(@Nonnull KeyStore keyStore) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            keyStore.store(outputStream, new char[0]);
            return Buffer.buffer((byte[])outputStream.toByteArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Unable to prepare keystore for TLS", e);
        }
    }

    @Provides
    @Singleton
    HttpServerOptions provideHttpServerOptions(@Nonnull UrlConfiguration defaultConfiguration, @Nonnull Lazy<Buffer> keyStoreBuffer) {
        HttpServerOptions options = new HttpServerOptions().setPort(defaultConfiguration.getPort());
        if (defaultConfiguration.getProtocol().isTls()) {
            options.setSsl(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setValue((Buffer)keyStoreBuffer.get()).setPassword(""));
        }
        return options;
    }

    @Provides
    @Singleton
    Router provideRouter(@Nonnull UrlConfiguration defaultConfiguration, @Nonnull Vertx vertx, @Nonnull CommonHandler commonHandler, @Nonnull FailureHandler failureHandler, @Nonnull JwksRoute jwksRoute, @Nonnull WellKnownRoute wellKnownRoute, @Nonnull LoginRoute loginRoute, @Nonnull AuthenticationRoute authenticationRoute, @Nonnull OptionalBasicAuthHandler basicAuthHandler, @Nonnull TokenRoute tokenRoute, @Nonnull IFrameRoute iframeRoute, @Nonnull @Named(value="webCryptoShimJs") ResourceFileHandler webCryptoShimJsHandler, @Nonnull @Named(value="cookie1") ResourceFileHandler thirdPartyCookies1Route, @Nonnull @Named(value="cookie2") ResourceFileHandler thirdPartyCookies2Route, @Nonnull LogoutRoute logoutRoute, @Nonnull OutOfBandLoginRoute outOfBandLoginRoute, @Nonnull @Named(value="keycloakJs") ResourceFileHandler keycloakJsRoute, @Nonnull @Named(value="stylesheet") ResourceFileHandler stylesheetRoute, @Nonnull DocumentationRoute documentationRoute) {
        UrlConfiguration routing = defaultConfiguration.forRequestContext(null, ":realm");
        Router router = Router.router((Vertx)vertx);
        router.route().handler((Handler)commonHandler).failureHandler((Handler)failureHandler).failureHandler((Handler)ErrorHandler.create((Vertx)vertx));
        router.get(routing.getJwksUri().getPath()).setName("key signing data").handler((Handler)jwksRoute);
        router.get(routing.getIssuerPath().resolve(".well-known/*").getPath()).setName("configuration discovery data").handler((Handler)wellKnownRoute);
        router.get(routing.getAuthorizationEndpoint().getPath()).setName("login page").handler((Handler)loginRoute);
        router.post(routing.getAuthenticationCallbackEndpoint(":sessionId").getPath()).setName("custom authentication endpoint used by login page").handler((Handler)BodyHandler.create()).handler((Handler)authenticationRoute);
        router.post(routing.getTokenEndpoint().getPath()).setName("token endpoint").handler((Handler)BodyHandler.create()).handler((Handler)basicAuthHandler).handler((Handler)tokenRoute);
        router.get(routing.getOpenIdPath("login-status-iframe.html*").getPath()).setName("Keycloak login iframe").handler((Handler)iframeRoute);
        router.get(IFrameRoute.getWebCryptoShimPath(routing).getPath()).setName("provided web-crypto-shim.js").handler((Handler)webCryptoShimJsHandler);
        router.get(routing.getOpenIdPath("3p-cookies/step1.html").getPath()).setName("keycloak third party cookies - step 1").handler((Handler)thirdPartyCookies1Route);
        router.get(routing.getOpenIdPath("3p-cookies/step2.html").getPath()).setName("Keycloak third party cookies - step 2").handler((Handler)thirdPartyCookies2Route);
        router.route(routing.getEndSessionEndpoint().getPath()).setName("logout endpoint").method(HttpMethod.GET).method(HttpMethod.POST).handler((Handler)logoutRoute);
        router.get(routing.getOutOfBandLoginLoginEndpoint().getPath()).setName("out-of-band login endpoint").handler((Handler)outOfBandLoginRoute);
        router.get(routing.getJsPath().resolve("keycloak.js").getPath()).setName("provided keycloak.js").handler((Handler)keycloakJsRoute);
        router.get("/style.css").handler((Handler)stylesheetRoute);
        router.get("/docs").setName("documentation endpoint").produces("text/html").handler((Handler)documentationRoute);
        return router;
    }

    @Provides
    @Singleton
    HttpServer provideServer(@Nonnull Vertx vertx, @Nonnull HttpServerOptions options, @Nonnull Router router) {
        return vertx.createHttpServer(options).requestHandler((Handler)router).exceptionHandler(t -> LOG.error("Exception while processing request", t));
    }

    @Provides
    @Singleton
    LoginRoleMapping provideLoginRoleMapping(@Nonnull ServerConfig serverConfig) {
        return serverConfig.getLoginRoleMapping();
    }

    @Provides
    @Singleton
    @Named(value="audiences")
    Collection<String> provideDefaultAudiences(@Nonnull ServerConfig serverConfig) {
        return serverConfig.getDefaultAudiences();
    }
}

