/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.helper.RedirectHelper;
import com.tngtech.keycloakmock.impl.helper.UserInputSanitizer;
import com.tngtech.keycloakmock.impl.session.PersistentSession;
import com.tngtech.keycloakmock.impl.session.SessionRepository;
import com.tngtech.keycloakmock.impl.session.SessionRequest;
import com.tngtech.keycloakmock.impl.session.UserData;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthenticationRoute
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationRoute.class);
    private static final String USERNAME_PARAMETER = "username";
    private static final String ROLES_PARAMETER = "password";
    @Nonnull
    private final SessionRepository sessionRepository;
    @Nonnull
    private final RedirectHelper redirectHelper;
    @Nonnull
    private final UrlConfiguration baseConfiguration;

    @Inject
    AuthenticationRoute(@Nonnull SessionRepository sessionRepository, @Nonnull RedirectHelper redirectHelper, @Nonnull UrlConfiguration baseConfiguration) {
        this.sessionRepository = sessionRepository;
        this.redirectHelper = redirectHelper;
        this.baseConfiguration = baseConfiguration;
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        String sessionId = routingContext.pathParam("sessionId");
        SessionRequest request = this.sessionRepository.getRequest(sessionId);
        if (request == null) {
            LOG.warn("Login for unknown session {} requested!", (Object)new UserInputSanitizer(sessionId));
            routingContext.fail(404);
            return;
        }
        String username = routingContext.request().getFormAttribute(USERNAME_PARAMETER);
        if (username == null) {
            LOG.warn("Missing username {}", (Object)new UserInputSanitizer(username));
            routingContext.fail(400);
            return;
        }
        String rolesString = routingContext.request().getFormAttribute(ROLES_PARAMETER);
        List roles = Optional.ofNullable(rolesString).map(s -> Arrays.asList(s.split(","))).orElseGet(Collections::emptyList);
        UrlConfiguration requestConfiguration = this.baseConfiguration.forRequestContext(routingContext);
        PersistentSession session = request.toSession(UserData.fromUsernameAndHostname(username, requestConfiguration.getHostname()), roles);
        this.sessionRepository.upgradeRequest(request, session);
        routingContext.response().addCookie(this.redirectHelper.getSessionCookie(session, requestConfiguration)).putHeader("location", this.redirectHelper.getRedirectLocation(session, requestConfiguration)).setStatusCode(302).end();
    }
}

