/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.PublicJwk;
import io.jsonwebtoken.security.PublicJwkBuilder;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.PublicKey;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class JwksRoute
implements Handler<RoutingContext> {
    private final String jwksResponse;

    @Inject
    JwksRoute(@Nonnull @Named(value="keyId") String keyId, @Nonnull PublicKey publicKey) {
        this.jwksResponse = new JsonObject().put("keys", (Object)new JsonArray(Collections.singletonList(JwksRoute.toSigningKey(keyId, publicKey)))).encode();
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        routingContext.response().putHeader("content-type", "application/json").end(this.jwksResponse);
    }

    private static JsonObject toSigningKey(@Nonnull String keyId, @Nonnull PublicKey publicKey) {
        return new JsonObject(Jwks.json((PublicJwk)((PublicJwk)((PublicJwkBuilder)((PublicJwkBuilder)Jwks.builder().key(publicKey).id(keyId)).publicKeyUse("sig")).build())));
    }
}

