/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OptionalBasicAuthHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(OptionalBasicAuthHandler.class);

    @Inject
    OptionalBasicAuthHandler() {
    }

    public void handle(@Nonnull RoutingContext routingContext) {
        String authorization = routingContext.request().getHeader(HttpHeaders.AUTHORIZATION);
        if (authorization != null) {
            try {
                String usernamePassword = new String(Base64.getDecoder().decode(authorization.replace("Basic ", "")), StandardCharsets.UTF_8);
                String[] split = usernamePassword.split(":", 2);
                UsernamePasswordCredentials credentials = split.length == 2 ? new UsernamePasswordCredentials(split[0], split[1]) : new UsernamePasswordCredentials(split[0], null);
                routingContext.setUser(User.create((JsonObject)credentials.toJson()));
            }
            catch (RuntimeException e) {
                LOG.warn("Unable to parse authorization header {}", (Object)authorization);
            }
        }
        routingContext.next();
    }
}

