/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.helper;

import com.tngtech.keycloakmock.api.LoginRoleMapping;
import com.tngtech.keycloakmock.api.TokenConfig;
import com.tngtech.keycloakmock.impl.TokenGenerator;
import com.tngtech.keycloakmock.impl.UrlConfiguration;
import com.tngtech.keycloakmock.impl.session.Session;
import com.tngtech.keycloakmock.impl.session.UserData;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class TokenHelper {
    private static final String NONCE = "nonce";
    @Nonnull
    private final TokenGenerator tokenGenerator;
    @Nonnull
    private final Collection<String> defaultAudiences;
    @Nonnull
    private final LoginRoleMapping loginRoleMapping;

    @Inject
    TokenHelper(@Nonnull TokenGenerator tokenGenerator, @Nonnull @Named(value="audiences") Collection<String> defaultAudiences, @Nonnull LoginRoleMapping loginRoleMapping) {
        this.tokenGenerator = tokenGenerator;
        this.defaultAudiences = defaultAudiences;
        this.loginRoleMapping = loginRoleMapping;
    }

    @Nullable
    public String getToken(@Nonnull Session session, @Nonnull UrlConfiguration requestConfiguration) {
        UserData userData = session.getUserData();
        TokenConfig.Builder builder = TokenConfig.aTokenConfig().withAuthorizedParty(session.getClientId()).withAudience(session.getClientId()).withAudiences(this.defaultAudiences).withSubject(userData.getSubject()).withPreferredUsername(userData.getPreferredUsername()).withGivenName(userData.getGivenName()).withFamilyName(userData.getFamilyName()).withName(userData.getName()).withEmail(userData.getEmail()).withSessionId(session.getSessionId()).withAuthenticationContextClassReference("1");
        if (session.getNonce() != null) {
            builder.withClaim(NONCE, session.getNonce());
        }
        switch (this.loginRoleMapping) {
            case TO_REALM: {
                builder.withRealmRoles(session.getRoles());
                break;
            }
            case TO_RESOURCE: {
                this.setResourceRoles(builder, session);
                break;
            }
            case TO_BOTH: {
                builder.withRealmRoles(session.getRoles());
                this.setResourceRoles(builder, session);
            }
        }
        return this.tokenGenerator.getToken(builder.build(), requestConfiguration);
    }

    private void setResourceRoles(@Nonnull TokenConfig.Builder builder, @Nonnull Session session) {
        builder.withResourceRoles(session.getClientId(), session.getRoles());
        for (String audience : this.defaultAudiences) {
            builder.withResourceRoles(audience, session.getRoles());
        }
    }

    @Nonnull
    public Map<String, Object> parseToken(@Nonnull String token) {
        return this.tokenGenerator.parseToken(token);
    }
}

