/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.session;

import com.tngtech.keycloakmock.impl.session.Session;
import com.tngtech.keycloakmock.impl.session.SessionRequest;
import com.tngtech.keycloakmock.impl.session.UserData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersistentSession
implements Session {
    @Nonnull
    private final String clientId;
    @Nonnull
    private final String sessionId;
    @Nonnull
    private final UserData userData;
    @Nonnull
    private final List<String> roles;
    @Nullable
    private final String state;
    @Nonnull
    private final String redirectUri;
    @Nonnull
    private final String responseType;
    @Nullable
    private final String responseMode;
    @Nullable
    private final String nonce;

    PersistentSession(@Nonnull SessionRequest request, @Nonnull UserData userData, @Nonnull List<String> roles) {
        this.clientId = request.getClientId();
        this.sessionId = request.getSessionId();
        this.userData = userData;
        this.roles = roles;
        this.state = request.getState();
        this.redirectUri = request.getRedirectUri();
        this.responseType = request.getResponseType();
        this.responseMode = request.getResponseMode();
        this.nonce = request.getNonce();
    }

    @Override
    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nonnull
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    @Nonnull
    public UserData getUserData() {
        return this.userData;
    }

    @Override
    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nonnull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Nonnull
    public String getResponseType() {
        return this.responseType;
    }

    @Nullable
    public String getResponseMode() {
        return this.responseMode;
    }

    @Override
    @Nullable
    public String getNonce() {
        return this.nonce;
    }
}

