/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.session;

import com.tngtech.keycloakmock.impl.session.ResponseMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ResponseType {
    ID_TOKEN(ResponseMode.FRAGMENT, false),
    ID_TOKEN_PLUS_TOKEN(ResponseMode.FRAGMENT, false),
    CODE(ResponseMode.QUERY, true),
    NONE(ResponseMode.QUERY, true);

    @Nonnull
    private final ResponseMode defaultMode;
    private final boolean differentModeAllowed;

    private ResponseType(ResponseMode defaultMode, boolean differentModeAllowed) {
        this.defaultMode = defaultMode;
        this.differentModeAllowed = differentModeAllowed;
    }

    @Nonnull
    public ResponseMode getValidResponseMode(@Nullable String responseMode) {
        if (!this.differentModeAllowed) {
            return this.defaultMode;
        }
        ResponseMode requestedMode = ResponseMode.fromValue(responseMode);
        if (requestedMode != null) {
            return requestedMode;
        }
        return this.defaultMode;
    }

    @Nullable
    public static ResponseType fromValueOrNull(@Nullable String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "id_token": {
                return ID_TOKEN;
            }
            case "token id_token": 
            case "id_token token": {
                return ID_TOKEN_PLUS_TOKEN;
            }
            case "code": {
                return CODE;
            }
            case "none": {
                return NONE;
            }
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case ID_TOKEN: {
                return "id_token";
            }
            case ID_TOKEN_PLUS_TOKEN: {
                return "id_token token";
            }
            case CODE: {
                return "code";
            }
            case NONE: {
                return "none";
            }
        }
        throw new IllegalStateException();
    }
}

