/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.keycloakmock.impl.session;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserData {
    @Nonnull
    private final String subject;
    @Nullable
    private final String givenName;
    @Nonnull
    private final String familyName;
    @Nonnull
    private final String email;
    @Nonnull
    private final String preferredUsername;

    private UserData(@Nonnull String subject, @Nullable String givenName, @Nonnull String familyName, @Nonnull String email, @Nonnull String preferredUsername) {
        this.subject = subject;
        this.givenName = givenName;
        this.familyName = familyName;
        this.email = email;
        this.preferredUsername = preferredUsername;
    }

    public static UserData fromUsernameAndHostname(@Nonnull String username, @Nonnull String hostname) {
        String email;
        String preferredUsername;
        int atIndex = username.indexOf("@");
        if (atIndex > 0) {
            preferredUsername = username.substring(0, atIndex);
            email = username.replace(' ', '+');
        } else {
            preferredUsername = username;
            email = username.replace(' ', '+') + "@" + hostname;
        }
        Name name = UserData.extractName(preferredUsername);
        return new UserData(username, name.givenName, name.familyName, email, preferredUsername);
    }

    @Nonnull
    private static Name extractName(@Nonnull String input) {
        List names = Arrays.stream(input.split("[._ ]")).filter(s -> !s.isEmpty()).map(s -> {
            String firstChar = s.substring(0, 1);
            return firstChar.toUpperCase() + s.substring(1);
        }).collect(Collectors.toList());
        if (names.isEmpty()) {
            return new Name(null, input);
        }
        if (names.size() == 1) {
            return new Name(null, (String)names.get(0));
        }
        int index = names.size() - 1;
        String familyName = (String)names.get(index);
        names.remove(index);
        return new Name(String.join((CharSequence)" ", names), familyName);
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public String getGivenName() {
        return this.givenName;
    }

    @Nonnull
    public String getFamilyName() {
        return this.familyName;
    }

    @Nonnull
    public String getEmail() {
        return this.email;
    }

    @Nonnull
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Nonnull
    public String getName() {
        return this.givenName != null ? this.givenName + " " + this.familyName : this.familyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserData userData = (UserData)o;
        return Objects.equals(this.subject, userData.subject) && Objects.equals(this.givenName, userData.givenName) && Objects.equals(this.familyName, userData.familyName) && Objects.equals(this.email, userData.email) && Objects.equals(this.preferredUsername, userData.preferredUsername);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.givenName, this.familyName, this.email, this.preferredUsername);
    }

    public String toString() {
        return "UserData{subject='" + this.subject + '\'' + ", givenName='" + this.givenName + '\'' + ", familyName='" + this.familyName + '\'' + ", email='" + this.email + '\'' + ", preferredUsername='" + this.preferredUsername + '\'' + '}';
    }

    private static class Name {
        @Nullable
        private final String givenName;
        @Nonnull
        private final String familyName;

        private Name(@Nullable String givenName, @Nonnull String familyName) {
            this.givenName = givenName;
            this.familyName = familyName;
        }
    }
}

