/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen;

import com.tobedevoured.modelcitizen.erector.Command;
import com.tobedevoured.modelcitizen.field.ModelField;
import com.tobedevoured.modelcitizen.template.BlueprintTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Erector {
    private static final Set<Command> emptySet = new HashSet<Command>();
    private Object blueprint;
    private List<ModelField> modelFields;
    private Map<ModelField, Set<Command>> modelFieldCommands = new HashMap<ModelField, Set<Command>>();
    private BlueprintTemplate blueprintTemplate;
    private Class target;
    private Object reference;

    public void addCommands(ModelField modelField, Set<Command> commands) {
        for (Command command : commands) {
            this.addCommand(modelField, command);
        }
    }

    public void addCommand(ModelField modelField, Command command) {
        Set<Command> commands = this.modelFieldCommands.get(modelField);
        if (commands == null) {
            commands = new HashSet<Command>();
        }
        commands.add(command);
        this.modelFieldCommands.put(modelField, commands);
    }

    public Set<Command> getCommands(ModelField modelField) {
        Set<Command> commands = this.modelFieldCommands.get(modelField);
        if (commands != null) {
            return commands;
        }
        return emptySet;
    }

    public void clearCommands() {
        this.modelFieldCommands = new HashMap<ModelField, Set<Command>>();
    }

    public Object getBlueprint() {
        return this.blueprint;
    }

    public void setBlueprint(Object blueprint) {
        this.blueprint = blueprint;
    }

    public List<ModelField> getModelFields() {
        return this.modelFields;
    }

    public void setModelFields(List<ModelField> modelFields) {
        this.modelFields = modelFields;
    }

    public BlueprintTemplate getTemplate() {
        return this.blueprintTemplate;
    }

    public void setTemplate(BlueprintTemplate blueprintTemplate) {
        this.blueprintTemplate = blueprintTemplate;
    }

    public Class getTarget() {
        return this.target;
    }

    public void setTarget(Class target) {
        this.target = target;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }
}

