/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen;

import com.metapossum.utils.scanner.reflect.ClassesInPackageScanner;
import com.tobedevoured.modelcitizen.CreateModelException;
import com.tobedevoured.modelcitizen.Erector;
import com.tobedevoured.modelcitizen.RegisterBlueprintException;
import com.tobedevoured.modelcitizen.annotation.Blueprint;
import com.tobedevoured.modelcitizen.annotation.Default;
import com.tobedevoured.modelcitizen.annotation.Mapped;
import com.tobedevoured.modelcitizen.annotation.MappedList;
import com.tobedevoured.modelcitizen.annotation.MappedSet;
import com.tobedevoured.modelcitizen.annotation.NotSet;
import com.tobedevoured.modelcitizen.annotation.Nullable;
import com.tobedevoured.modelcitizen.erector.Command;
import com.tobedevoured.modelcitizen.field.DefaultField;
import com.tobedevoured.modelcitizen.field.FieldCallBack;
import com.tobedevoured.modelcitizen.field.MappedField;
import com.tobedevoured.modelcitizen.field.MappedListField;
import com.tobedevoured.modelcitizen.field.MappedSetField;
import com.tobedevoured.modelcitizen.field.ModelField;
import com.tobedevoured.modelcitizen.policy.BlueprintPolicy;
import com.tobedevoured.modelcitizen.policy.FieldPolicy;
import com.tobedevoured.modelcitizen.policy.Policy;
import com.tobedevoured.modelcitizen.policy.PolicyException;
import com.tobedevoured.modelcitizen.template.BlueprintTemplateException;
import com.tobedevoured.modelcitizen.template.JavaBeanTemplate;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Object> blueprints;
    private Map<Class, Erector> erectors = new HashMap<Class, Erector>();
    private Map<Class, List<FieldPolicy>> fieldPolicies = new HashMap<Class, List<FieldPolicy>>();
    private Map<Class, List<BlueprintPolicy>> blueprintPolicies = new HashMap<Class, List<BlueprintPolicy>>();

    public ModelFactory() {
        this.blueprints = new ArrayList<Object>();
        this.erectors = new HashMap<Class, Erector>();
    }

    public void addPolicy(Policy policy) throws PolicyException {
        if (policy instanceof BlueprintPolicy) {
            if (this.erectors.get(policy.getTarget()) == null) {
                throw new PolicyException("Blueprint does not exist for BlueprintPolicy target: " + policy.getTarget());
            }
            List<BlueprintPolicy> policies = this.blueprintPolicies.get(policy.getTarget());
            if (policies == null) {
                policies = new ArrayList<BlueprintPolicy>();
            }
            policies.add((BlueprintPolicy)policy);
            this.logger.info("Setting BlueprintPolicy {} for {}", (Object)policy, (Object)policy.getTarget());
            this.blueprintPolicies.put(policy.getTarget(), policies);
        } else if (policy instanceof FieldPolicy) {
            if (this.erectors.get(policy.getTarget()) == null) {
                throw new PolicyException("Blueprint does not exist for FieldPolicy target: " + policy.getTarget());
            }
            List<FieldPolicy> policies = this.fieldPolicies.get(policy.getTarget());
            if (policies == null) {
                policies = new ArrayList<FieldPolicy>();
            }
            policies.add((FieldPolicy)policy);
            this.logger.info("Setting FieldPolicy {} for {}", (Object)policy, (Object)policy.getTarget());
            this.fieldPolicies.put(policy.getTarget(), policies);
        }
    }

    public void setRegisterBlueprintsByPackage(String _package) throws RegisterBlueprintException {
        Set annotated = null;
        try {
            annotated = new ClassesInPackageScanner().findAnnotatedClasses(_package, Blueprint.class);
        }
        catch (IOException e) {
            throw new RegisterBlueprintException(e);
        }
        this.logger.info("Scanned {} and found {}", (Object)_package, (Object)annotated);
        this.setRegisterBlueprints(annotated);
    }

    public void setRegisterBlueprints(Collection blueprints) throws RegisterBlueprintException {
        for (Object blueprint : blueprints) {
            if (blueprint instanceof Class) {
                this.registerBlueprint((Class)blueprint);
                continue;
            }
            if (blueprint instanceof String) {
                this.registerBlueprint((String)blueprint);
                continue;
            }
            if (blueprint instanceof String) {
                this.registerBlueprint(blueprint);
                continue;
            }
            throw new RegisterBlueprintException("Only supports List comprised of Class<Blueprint>, Blueprint, or String className");
        }
    }

    public void registerBlueprint(String className) throws RegisterBlueprintException {
        try {
            this.registerBlueprint(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new RegisterBlueprintException(e);
        }
    }

    public void registerBlueprint(Class clazz) throws RegisterBlueprintException {
        Object blueprint = null;
        try {
            blueprint = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RegisterBlueprintException(e);
        }
        catch (IllegalAccessException e) {
            throw new RegisterBlueprintException(e);
        }
        this.registerBlueprint((Object)blueprint);
    }

    public void registerBlueprint(Object blueprint) throws RegisterBlueprintException {
        Field[] fields;
        Blueprint blueprintAnnotation = blueprint.getClass().getAnnotation(Blueprint.class);
        if (blueprintAnnotation == null) {
            throw new RegisterBlueprintException("Blueprint class not annotated by @Blueprint: " + blueprint);
        }
        Class target = blueprintAnnotation.value();
        ArrayList<ModelField> modelFields = new ArrayList<ModelField>();
        this.logger.debug("Registering blueprint for {}", (Object)target);
        Field[] fieldArray = fields = blueprint.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            MappedSet mappedSet;
            int n3;
            MappedList mappedCollection;
            Mapped mapped;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.getAnnotation(Default.class) != null) {
                DefaultField defaultField = new DefaultField();
                defaultField.setName(field.getName());
                try {
                    defaultField.setValue(field.get(blueprint));
                }
                catch (IllegalArgumentException e) {
                    throw new RegisterBlueprintException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RegisterBlueprintException(e);
                }
                defaultField.setTarget(field.getType());
                defaultField.setFieldClass(field.getType());
                modelFields.add(defaultField);
                this.logger.debug("  Setting default for {} to {}", (Object)defaultField.getName(), defaultField.getValue());
            }
            if ((mapped = field.getAnnotation(Mapped.class)) != null) {
                MappedField mappedField = new MappedField();
                mappedField.setName(field.getName());
                if (field.getAnnotation(Nullable.class) != null) {
                    mappedField.setNullable(true);
                }
                if (NotSet.class.equals((Object)mapped.target())) {
                    mappedField.setTarget(field.getType());
                } else {
                    mappedField.setTarget(mapped.target());
                }
                mappedField.setFieldClass(field.getType());
                modelFields.add(mappedField);
                this.logger.debug("  Setting mapped for {} to {}", (Object)mappedField.getName(), (Object)mappedField.getTarget());
            }
            if ((mappedCollection = field.getAnnotation(MappedList.class)) != null) {
                MappedListField listField = new MappedListField();
                listField.setName(field.getName());
                listField.setFieldClass(field.getType());
                listField.setSize(mappedCollection.size());
                if (NotSet.class.equals((Object)mappedCollection.target())) {
                    listField.setTarget(field.getType());
                } else {
                    listField.setTarget(mappedCollection.target());
                }
                if (NotSet.class.equals((Object)mappedCollection.targetList())) {
                    listField.setTargetList(ArrayList.class);
                } else {
                    boolean implementsList = false;
                    Class<?>[] classArray = mappedCollection.targetList().getInterfaces();
                    n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> interf = classArray[n4];
                        if (List.class.equals(interf)) {
                            implementsList = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!implementsList) {
                        throw new RegisterBlueprintException("@MappedList targetList must implement List for field " + field.getName());
                    }
                    listField.setTargetList(mappedCollection.targetList());
                }
                modelFields.add(listField);
                this.logger.debug("  Setting mapped list for {} to {} as <{}>", new Object[]{listField.getName(), listField.getFieldClass(), listField.getTarget()});
            }
            if ((mappedSet = field.getAnnotation(MappedSet.class)) != null) {
                MappedSetField setField = new MappedSetField();
                setField.setName(field.getName());
                setField.setFieldClass(field.getType());
                setField.setSize(mappedSet.size());
                if (NotSet.class.equals((Object)mappedSet.target())) {
                    setField.setTarget(field.getType());
                } else {
                    setField.setTarget(mappedSet.target());
                }
                if (NotSet.class.equals((Object)mappedSet.targetSet())) {
                    setField.setTargetSet(HashSet.class);
                } else {
                    boolean implementsSet = false;
                    Class<?>[] classArray = mappedSet.targetSet().getInterfaces();
                    int n5 = classArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        Class<?> interf = classArray[n3];
                        if (Set.class.equals(interf)) {
                            implementsSet = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!implementsSet) {
                        throw new RegisterBlueprintException("@MappedSet targetSet must implement Set for field " + field.getName());
                    }
                    setField.setTargetSet(mappedSet.targetSet());
                }
                modelFields.add(setField);
                this.logger.debug("  Setting mapped set for {} to {} as <{}>", new Object[]{setField.getName(), setField.getFieldClass(), setField.getTarget()});
            }
            ++n2;
        }
        this.blueprints.add(blueprint);
        Erector erector = new Erector();
        erector.setTemplate(new JavaBeanTemplate());
        erector.setBlueprint(blueprint);
        erector.setModelFields(modelFields);
        erector.setTarget(target);
        this.erectors.put(target, erector);
    }

    public <T> T createModel(Class<T> clazz) throws CreateModelException {
        try {
            return this.createModel(clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new CreateModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new CreateModelException(e);
        }
    }

    public <T> T createModel(Class<T> clazz, boolean withPolicies) throws CreateModelException {
        try {
            return this.createModel(clazz.newInstance(), withPolicies);
        }
        catch (InstantiationException e) {
            throw new CreateModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new CreateModelException(e);
        }
    }

    public <T> T createModel(T referenceModel) throws CreateModelException {
        return this.createModel(referenceModel, true);
    }

    public <T> T createModel(T referenceModel, boolean withPolicies) throws CreateModelException {
        List<BlueprintPolicy> blueprintPolicies;
        Object createdModel;
        Erector erector = this.erectors.get(referenceModel.getClass());
        if (erector == null) {
            throw new CreateModelException("Unregistered class: " + referenceModel.getClass());
        }
        erector.setReference(referenceModel);
        erector.clearCommands();
        try {
            createdModel = erector.getTemplate().construct(erector.getTarget());
        }
        catch (BlueprintTemplateException e) {
            throw new CreateModelException(e);
        }
        if (withPolicies && (blueprintPolicies = this.getBlueprintPolicies().get(erector.getTarget())) != null) {
            this.logger.debug("  Running Blueprint policies");
            for (BlueprintPolicy policy : blueprintPolicies) {
                Map<ModelField, Set<Command>> modelFieldCommands = null;
                try {
                    this.logger.info("    processing {}", (Object)policy);
                    modelFieldCommands = policy.process(this, erector, createdModel);
                }
                catch (PolicyException e) {
                    new CreateModelException(e);
                }
                for (ModelField modelField : modelFieldCommands.keySet()) {
                    erector.addCommands(modelField, modelFieldCommands.get(modelField));
                }
            }
        }
        for (ModelField modelField : erector.getModelFields()) {
            List<FieldPolicy> fieldPolicies;
            this.logger.debug("ModelField {}", (Object)ReflectionToStringBuilder.toString((Object)modelField));
            Object value = null;
            if (withPolicies && (fieldPolicies = this.getFieldPolicies().get(modelField.getTarget())) != null) {
                this.logger.debug("  Running Field policies");
                for (FieldPolicy policy : fieldPolicies) {
                    try {
                        this.logger.info("    processing {} for {}", (Object)policy, (Object)modelField.getTarget());
                        Command command = policy.process(this, erector, modelField, createdModel);
                        if (command == null) continue;
                        erector.addCommand(modelField, command);
                    }
                    catch (PolicyException e) {
                        new CreateModelException(e);
                    }
                }
            }
            if (erector.getCommands(modelField).size() > 0) {
                this.logger.debug("  ModelField commands: {}", erector.getCommands(modelField));
            }
            if (erector.getCommands(modelField).contains(Command.SKIP_INJECTION)) continue;
            if (modelField instanceof DefaultField) {
                DefaultField defaultField = (DefaultField)modelField;
                if (!erector.getCommands(modelField).contains(Command.SKIP_REFERENCE_INJECTION)) {
                    try {
                        value = erector.getTemplate().get(referenceModel, defaultField.getName());
                    }
                    catch (BlueprintTemplateException e) {
                        throw new CreateModelException(e);
                    }
                }
                if (!erector.getCommands(modelField).contains(Command.SKIP_BLUEPRINT_INJECTION) && value == null) {
                    value = defaultField.getValue();
                }
                if (value != null & value instanceof FieldCallBack) {
                    FieldCallBack callBack = (FieldCallBack)value;
                    value = callBack.get(referenceModel);
                }
                try {
                    createdModel = erector.getTemplate().set(createdModel, defaultField.getName(), value);
                    continue;
                }
                catch (BlueprintTemplateException e) {
                    throw new CreateModelException(e);
                }
            }
            if (modelField instanceof MappedField) {
                MappedField mappedField = (MappedField)modelField;
                if (!erector.getCommands(modelField).contains(Command.SKIP_REFERENCE_INJECTION)) {
                    try {
                        value = erector.getTemplate().get(referenceModel, mappedField.getName());
                    }
                    catch (BlueprintTemplateException e) {
                        throw new CreateModelException(e);
                    }
                }
                if (!erector.getCommands(modelField).contains(Command.SKIP_BLUEPRINT_INJECTION) && value == null && !mappedField.isNullable()) {
                    value = this.createModel((T)mappedField.getTarget());
                }
                try {
                    createdModel = erector.getTemplate().set(createdModel, mappedField.getName(), value);
                    continue;
                }
                catch (BlueprintTemplateException e) {
                    throw new CreateModelException(e);
                }
            }
            if (modelField instanceof MappedListField) {
                MappedListField listField = (MappedListField)modelField;
                List modelList = null;
                try {
                    value = (List)erector.getTemplate().construct(listField.getTargetList());
                }
                catch (BlueprintTemplateException e) {
                    throw new CreateModelException(e);
                }
                if (!erector.getCommands(modelField).contains(Command.SKIP_INJECTION)) {
                    try {
                        modelList = (List)erector.getTemplate().get(referenceModel, listField.getName());
                    }
                    catch (BlueprintTemplateException e) {
                        throw new CreateModelException(e);
                    }
                }
                if (!erector.getCommands(modelField).contains(Command.SKIP_BLUEPRINT_INJECTION)) {
                    if (modelList == null) {
                        int x = 0;
                        while (x < listField.getSize()) {
                            ((List)value).add(this.createModel((T)listField.getTarget()));
                            ++x;
                        }
                    } else {
                        for (Object object : modelList) {
                            ((List)value).add(this.createModel(object));
                        }
                    }
                }
                try {
                    createdModel = erector.getTemplate().set(createdModel, listField.getName(), value);
                    continue;
                }
                catch (BlueprintTemplateException e) {
                    throw new CreateModelException(e);
                }
            }
            if (!(modelField instanceof MappedSetField)) continue;
            MappedSetField setField = (MappedSetField)modelField;
            try {
                value = erector.getTemplate().construct(setField.getTargetSet());
            }
            catch (BlueprintTemplateException e) {
                throw new CreateModelException(e);
            }
            Set referenceModelSet = null;
            if (!erector.getCommands(modelField).contains(Command.SKIP_INJECTION)) {
                try {
                    referenceModelSet = (Set)erector.getTemplate().get(referenceModel, setField.getName());
                }
                catch (BlueprintTemplateException e) {
                    throw new CreateModelException(e);
                }
            }
            if (!erector.getCommands(modelField).contains(Command.SKIP_BLUEPRINT_INJECTION)) {
                if (referenceModelSet == null) {
                    int x = 0;
                    while (x < setField.getSize()) {
                        ((Set)value).add(this.createModel((T)setField.getTarget()));
                        ++x;
                    }
                } else {
                    for (Object object : referenceModelSet) {
                        ((Set)value).add(this.createModel(object));
                    }
                }
            }
            try {
                createdModel = erector.getTemplate().set(createdModel, setField.getName(), value);
            }
            catch (BlueprintTemplateException e) {
                throw new CreateModelException(e);
            }
        }
        return createdModel;
    }

    public List<Object> getBlueprints() {
        return this.blueprints;
    }

    public Map<Class, Erector> getErectors() {
        return this.erectors;
    }

    public Map<Class, List<BlueprintPolicy>> getBlueprintPolicies() {
        return this.blueprintPolicies;
    }

    public Map<Class, List<FieldPolicy>> getFieldPolicies() {
        return this.fieldPolicies;
    }
}

