/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen.policy;

import com.tobedevoured.modelcitizen.CreateModelException;
import com.tobedevoured.modelcitizen.Erector;
import com.tobedevoured.modelcitizen.ModelFactory;
import com.tobedevoured.modelcitizen.erector.Command;
import com.tobedevoured.modelcitizen.field.MappedField;
import com.tobedevoured.modelcitizen.field.ModelField;
import com.tobedevoured.modelcitizen.policy.FieldPolicy;
import com.tobedevoured.modelcitizen.policy.PolicyException;
import com.tobedevoured.modelcitizen.template.BlueprintTemplateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedSingletonPolicy
implements FieldPolicy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class singletonClass;
    private Object singleton;

    public MappedSingletonPolicy(Class singletonClass) {
        this.singletonClass = singletonClass;
    }

    public MappedSingletonPolicy(Object model) {
        this.singleton = model;
        this.singletonClass = this.singleton.getClass();
    }

    public Object getSingleton() {
        return this.singleton;
    }

    public void setSingleton(Object singleton) {
        this.singleton = singleton;
    }

    @Override
    public Command process(ModelFactory modelFactory, Erector erector, ModelField modelField, Object model) throws PolicyException {
        this.logger.debug("processing {} for {}", (Object)modelField, model);
        if (modelField instanceof MappedField) {
            if (this.getSingleton() == null) {
                this.logger.debug("  creating singleton for {}", (Object)this.getTarget());
                try {
                    this.setSingleton(modelFactory.createModel(this.getTarget(), false));
                }
                catch (CreateModelException e) {
                    throw new PolicyException(e);
                }
            }
            try {
                erector.getTemplate().set(model, modelField.getName(), this.getSingleton());
            }
            catch (BlueprintTemplateException e) {
                throw new PolicyException(e);
            }
        }
        return Command.SKIP_INJECTION;
    }

    @Override
    public Class getTarget() {
        return this.singletonClass;
    }
}

